package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

/**
 * Created by mika on 2016. 3. 21..
 */
public class CompareUtils {
  public static boolean isSame(String s1, String s2) {
    return compare(s1, s2) == 0;
  }

  public static int compare(String s1, String s2) {
    if (TextUtils.isEmpty(s1) && TextUtils.isEmpty(s2)) { return 0; }
    if (TextUtils.isEmpty(s1)) { return 1; }
    if (TextUtils.isEmpty(s2)) { return -1; }

    int result;
    int end = Math.min(s1.length(), s2.length());
    char c1, c2;
    int i1, i2;
    for (int i = 0; i < end; ++i) {
      if ((c1 = s1.charAt(i)) == (c2 = s2.charAt(i))) {
        continue;
      }

      i1 = asciiCase(c1);
      i2 = asciiCase(c2);

      if ((result = i1 - i2) != 0) {
        return result;
      }

      c1 = foldCase(c1);
      c2 = foldCase(c2);
      if ((result = c1 - c2) != 0) {
        return result;
      }
    }
    return s1.length() - s2.length();
  }

  public static int compare(int lhs, int rhs) {
    return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
  }

  public static int compare(Long lhs, Long rhs) {
    if (lhs == null && rhs == null) {
      return 0;
    }
    if (lhs == null) {
      return 1;
    }
    if (rhs == null) {
      return -1;
    }

    return lhs < rhs ? -1 : (lhs.equals(rhs) ? 0 : 1);
  }

  public static String max(String s1, String s2) {
    if (CompareUtils.compare(s1, s2) < 0) {
      return s2;
    }
    return s1;
  }

  public static String min(String s1, String s2) {
    if (CompareUtils.compare(s1, s2) < 0) {
      return s1;
    }
    return s2;
  }

  /**
   * Compares target to the specified values.
   *
   * @param  target
   *         The target to compare, null allows.
   *
   * @param  values
   *         values to compare
   *
   * @return  return boolean if target is exists in values.
   */
  @SafeVarargs
  public static <E extends Comparable> boolean exists(E target, E... values) {
    for (E ee : values) {
      if (ee == null) {
        if (target == null) { return true; }
      } else if (ee.equals(target)) {
        return true;
      }
    }
    return false;
  }

  private static int asciiCase(char ch) {
    return ch < 128 ? 1 : 0;
  }

  private static char foldCase(char ch) {
    if (ch < 128) {
      if ('A' <= ch && ch <= 'Z') {
        return (char) (ch + ('a' - 'A'));
      }
      return ch;
    }
    return Character.toLowerCase(Character.toUpperCase(ch));
  }

  public static boolean isSameActivity(@Nullable Context context1, @Nullable Context context2) {
    return context1 != null && context2 != null && context1.hashCode() == context2.hashCode();
  }

  public static boolean oneOf(int target, int... items) {
    for (int item : items) {
      if (target == item) {
        return true;
      }
    }
    return false;
  }
}

