package com.zoyi.channel.plugin.android.store2;

import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.wrapper.MessengersRepo;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.store2.state.EnumState;
import com.zoyi.channel.plugin.android.store2.state.State;

public class ChannelStore extends Store2 {

  public State<Channel> channelState = new State<>();
  public EnumState<FetchState> channelFetchState = new EnumState<>(FetchState.COMPLETE);

  public State<MessengersRepo> messengers = new State<>();
  public EnumState<FetchState> messengersFetchState = new EnumState<>(FetchState.LOADING);

  @Override
  protected void reset() {
    channelState.reset();
    channelFetchState.reset();
    messengers.reset();
    messengersFetchState.reset();
  }

  public static ChannelStore get() {
    return Store2.getInstance(ChannelStore.class);
  }
}
