package com.zoyi.channel.plugin.android.selector2;

import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder2;
import com.zoyi.channel.plugin.android.store2.state.EntityMapState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.rx.functions.Action1;

public class GuestSelector {

  public static Binder bindGuestAlertCount(Action1<Integer> action1) {
    EntityMapState<PushBotItem> pushBotItemsState = PushBotStore.get().pushBots;
    State<Guest> guestState = GuestStore.get().guest;

    return new Binder2<>(pushBotItemsState, guestState).bind((pushBotItems, guest) -> {
      if (guest != null) {
        int pushBotActiveCount = 0;

        for (PushBotItem pushBotItem : pushBotItems.values()) {
          if (pushBotItem.isActive()) {
            pushBotActiveCount += pushBotItem.getAlertCount();
          }
        }

        action1.call(guest.getAlert() + pushBotActiveCount);
      }
    });
  }
}
