package com.zoyi.channel.plugin.android.glide;

import android.content.Context;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.GlideBuilder;
import com.zoyi.com.bumptech.glide.load.model.GlideUrl;
import com.zoyi.com.bumptech.glide.module.GlideModule;
import com.zoyi.okhttp3.OkHttpClient;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;

/**
 * Created by mika on 2018. 11. 30..
 */

public class ChannelPluginGlideModule implements GlideModule {

  @Override
  public void applyOptions(Context context, GlideBuilder glideBuilder) {
  }

  @Override
  public void registerComponents(Context context, Glide glide) {
    OkHttpClient client = new OkHttpClient.Builder()
        .connectTimeout(45, TimeUnit.SECONDS)
        .readTimeout(45, TimeUnit.SECONDS)
        .writeTimeout(45, TimeUnit.SECONDS)
        .build();

    glide.register(GlideUrl.class, InputStream.class, new OkHttpUrlLoader.Factory(client));
  }
}
