package com.zoyi.channel.plugin.android.activity.settings2.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.zoyi.com.google.i18n.phonenumbers.Phonenumber;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.settings2.enumerate.OptionType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.util.ProfileUtils;

public class SettingsOptionView extends LinearLayout implements View.OnClickListener {

  private TextView textLabel;
  private TextView textValue;
  private TextView textPlaceholder;

  @Nullable
  private SettingsOptionInteractionListener settingsOptionInteractionListener;

  private OptionType optionType = OptionType.NONE;

  @Nullable
  private String key;

  @Nullable
  private String value;

  public SettingsOptionView(Context context) {
    super(context);
    init(context);
  }

  public SettingsOptionView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public SettingsOptionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_settings_option, this, true);

    view.setOnClickListener(this);

    textLabel = view.findViewById(R.id.textSettingsOptionLabel);
    textValue = view.findViewById(R.id.textSettingsOptionValue);
    textPlaceholder = view.findViewById(R.id.textSettingsOptionPlaceholder);
  }

  public void setSettingsOptionInteractionListener(
      @Nullable SettingsOptionInteractionListener settingsOptionInteractionListener
  ) {
    this.settingsOptionInteractionListener = settingsOptionInteractionListener;
  }

  public void setData(OptionType optionType, String text) {
    this.optionType = optionType;
    this.key = null;
    this.value = null;

    this.textLabel.setVisibility(View.GONE);
    this.textValue.setVisibility(View.VISIBLE);
    this.textValue.setText(text);
    this.textPlaceholder.setVisibility(View.GONE);
  }

  public void setData(ProfileBotSchema schema, Guest guest) {
    this.optionType = OptionType.PROFILE;
    this.key = schema.getKey();
    this.value = ProfileUtils.getFormattedString(guest.getProfileValue(schema.getKey()));

    this.textLabel.setVisibility(View.VISIBLE);
    this.textLabel.setText(schema.getNameI18n().get());

    if (value != null && !TextUtils.isEmpty(value)) {
      this.textValue.setVisibility(View.VISIBLE);
      this.textPlaceholder.setVisibility(View.GONE);

      this.textValue.setText(getFormattedValue(key, value));
    } else {
      this.textValue.setVisibility(View.GONE);
      this.textPlaceholder.setVisibility(View.VISIBLE);
    }
  }

  private String getFormattedValue(String key, String value) {
    if (Const.PROFILE_MOBILE_NUMBER_KEY.equals(key)) {
      PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
      try {
        Phonenumber.PhoneNumber numberProto = phoneUtil.parse(value, "");
        return phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
      } catch (Exception ignored) {
      }
    }
    return ProfileUtils.getFormattedString(value);
  }

  @Override
  public void onClick(View v) {
    if (settingsOptionInteractionListener != null) {
      settingsOptionInteractionListener.onOptionClick(optionType, key, value);
    }
  }
}
