package com.zoyi.channel.plugin.android.activity.common.userchat.viewholder;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;

public class ChatHolder extends RecyclerView.ViewHolder implements View.OnClickListener, View.OnLongClickListener {

  @Nullable
  private OnChatClickListener listener;

  @Nullable
  private ChatItem chatItem;

  private AvatarLayout avatar;
  private CHTextView textName;
  private CHTextView textMessage;
  private CHTextView textTime;
  private CHTextView textBadge;

  @Initializer
  public ChatHolder(View itemView, @Nullable OnChatClickListener listener) {
    super(itemView);

    this.listener = listener;

    avatar = itemView.findViewById(R.id.avatar_single);
    avatar.setTextSize(16);

    textName = itemView.findViewById(R.id.text_name);
    textMessage = itemView.findViewById(R.id.text_message);
    textTime = itemView.findViewById(R.id.text_time);
    textBadge = itemView.findViewById(R.id.text_badge);

    itemView.setOnClickListener(this);
    itemView.setOnLongClickListener(this);
  }

  public void bind(ChatItem chatItem) {
    this.chatItem = chatItem;

    avatar.set(chatItem.getProfile());

    textName.setText(chatItem.getProfile() != null ? chatItem.getProfile().getName() : "");

    int alert = chatItem.getCount();
    Views.setVisibility(textBadge, alert > 0, View.INVISIBLE);
    textBadge.setText(Utils.getCount(alert, true));

    textTime.setText(TimeUtils.get(chatItem.getUpdatedAt()));

    textMessage.setText(ParseUtils.parseMessage(chatItem.getMessage()));
    textMessage.setTextColor(ResUtils.getColor(chatItem.isActive() ? R.color.ch_dark : R.color.ch_light));
  }

  @Override
  public void onClick(View v) {
    if (listener != null && chatItem != null) {
      listener.onChatItemClick(chatItem);
    }
  }

  @Override
  public boolean onLongClick(View v) {
    if (listener != null && chatItem != null) {
      listener.onChatItemLongClick(chatItem);
    }
    return true;
  }

  public static ChatHolder newInstance(ViewGroup parent, @Nullable OnChatClickListener listener) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());
    View itemView = inflater.inflate(R.layout.ch_plugin_item_chat, parent, false);

    return new ChatHolder(itemView, listener);
  }
}
