package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.graphics.Point;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;

/**
 * Created by mika on 2017. 3. 2..
 */
public class SendingMessageHolder extends ContentMessageHolder {


  private View rootMessageContentSending;

  private ImageView imageSendingMessage;
  private ImageView imageSendingMessageFailUpload;
  private MaskableFrameLayout frameSendingMessageImage;

  private CircularProgressView progressSendingMessage;

  @Nullable
  private SendingMessageItem sendingMessageItem;

  public static SendingMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnMessageContentClickListener onMessageContentClickListener
  ) {
    return new SendingMessageHolder(getItemView(parent, messageType), messageType, onMessageContentClickListener);
  }

  private SendingMessageHolder(
      View itemView,
      MessageType messageType,
      final @Nullable OnMessageContentClickListener onMessageContentClickListener
  ) {
    super(itemView, messageType, null);

    this.context = itemView.getContext();

    rootMessageContentSending = itemView.findViewById(R.id.ch_root_message_content_sending);

    frameSendingMessageImage = itemView.findViewById(R.id.ch_frame_sending_message_image);
    imageSendingMessage = itemView.findViewById(R.id.ch_image_sending_message);
    imageSendingMessageFailUpload = itemView.findViewById(R.id.ch_image_sending_message_upload_failed);
    progressSendingMessage = itemView.findViewById(R.id.ch_progress_sending_message);

    // Set resend button click event
    setResendMessageButtonClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (onMessageContentClickListener != null && sendingMessageItem != null) {
          onMessageContentClickListener.onResendButtonClick(sendingMessageItem);
        }
      }
    });
  }

  public void bind(final SendingMessageItem item, boolean isConnectedMessage) {
    super.bind(null, item.getType(), true);
    super.setGuestMessageInfo(item, isConnectedMessage);

    this.sendingMessageItem = item;

    setResendMessageButtonVisibility(item.getSendingState() == SendingState.FAIL);

    switch (sendingMessageItem.getContentType()) {
      case TEXT:
        setSendingTextMessage(item.getText(), isConnectedMessage);
        break;

      case ACTION:
        ActionButton actionButton = item.getActionButton();
        if (actionButton != null) {
          setSendingTextMessage(actionButton.getText(), isConnectedMessage);
        }
        break;

      case FILE:
        setSendingImageMessage(item.getFilePath(), item.getSendingState() == SendingState.FAIL);
        break;
    }
  }

  private void setSendingImageMessage(@Nullable String imagePath, boolean isFailedReplyMessage) {
    if (imagePath != null) {
      rootMessageContentSending.setVisibility(View.VISIBLE);

      Point previewImageSize = Utils.resizeImage(context, Utils.getLocalImageSize(imagePath), false);
      Resizer.size(frameSendingMessageImage, previewImageSize.x, previewImageSize.y);

      Glide.with(itemView.getContext())
          .load(imagePath)
          .asBitmap()
          .override(previewImageSize.x, previewImageSize.y)
          .dontAnimate()
          .centerCrop()
          .into(imageSendingMessage);

      Views.setVisibility(progressSendingMessage, !isFailedReplyMessage);
      Views.setVisibility(imageSendingMessageFailUpload, isFailedReplyMessage);
    }
  }

  private void setSendingTextMessage(@Nullable String text, boolean isConnected) {
    SpannableStringBuilder sendingText = ParseUtils.parseMessage(text);

    if (MessageUtils.hasOnlyEmoji(sendingText)) {
      setGiantEmoji(sendingText);
    } else {
      setGuestMessageText(sendingText, isConnected);
    }
  }
}
