package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.PushBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.MessageButton;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.Message;

import java.util.Collections;

/**
 * Created by mika on 2018. 11. 30..
 */

public class PushBotMessageHolder extends ContentMessageHolder {

  @Nullable
  private PushBotItem pushBotItem;

  public static PushBotMessageHolder newInstance(
      ViewGroup parent,
      @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    return new PushBotMessageHolder(
        getItemView(parent, MessageType.PUSH_BOT),
        MessageType.PUSH_BOT,
        onMessageContentClickListener);
  }

  private PushBotMessageHolder(
      View itemView,
      MessageType messageType,
      @Nullable final OnMessageContentClickListener onMessageContentClickListener) {
    super(itemView, messageType, onMessageContentClickListener);
  }

  public void bind(PushBotMessageItem item) {
    Message message = item.getMessage();
    pushBotItem = item.getPushBotItem();

    super.bind(message, MessageType.PUSH_BOT, false);
    setHostMessageText(message.getFormattedSpanMessage(), false);

    String attachment = pushBotItem.getAttachment();
    if (attachment != null) {
      switch (attachment) {
        case Const.PUSH_BOT_ATTACHMENT_BUTTON:
          if (pushBotItem.getButtonTitle() != null && pushBotItem.getButtonRedirectUrl() != null) {
            MessageButton pushBotMessageButton = new MessageButton(pushBotItem.getButtonTitle(), pushBotItem.getButtonRedirectUrl());
            setMessageButtons(Collections.singletonList(pushBotMessageButton));
          }
          break;

        case Const.PUSH_BOT_ATTACHMENT_IMAGE:
          Previewable imageThumb = pushBotItem.getImageThumb();
          String imageRedirectUrl = pushBotItem.getImageRedirectUrl();

          if (imageThumb != null) {
            if (imageRedirectUrl != null) {
              setLinkableImage(imageThumb);
            } else {
              setImage(imageThumb);
            }
          }
          break;
      }
    }
  }

  @Override
  protected void onImageClick() {
    if (onMessageContentClickListener != null && pushBotItem != null) {
      onMessageContentClickListener.onLocalImageClick(pushBotItem.getImageThumb());
    }
  }

  @Override
  protected void onLinkableImageClick() {
    if (onMessageContentClickListener != null && pushBotItem != null) {
      onMessageContentClickListener.onRedirectContentsClick(pushBotItem.getImageRedirectUrl());
    }
  }
}
