package com.zoyi.channel.plugin.android.action;

import android.app.Activity;
import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.PushBotReachRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.push_bot.PushBotManager;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ObjectUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;

import java.util.HashMap;
import java.util.Map;

public class EventAction {

  public static void trackPageView() {
    Map<String, Object> property = new HashMap<>();
    Activity activity = GlobalStore.get().topActivity.get();

    if (activity != null && !ChannelUtils.isChannelPluginActivity(activity)) {
      property.put(Const.PROPERTY_URL, activity.getClass().getSimpleName());
    }

    track(new Event(Const.PAGE_VIEW_EVENT_NAME, property));
  }

  public static void track(Event event) {
    Plugin plugin = PluginStore.get().pluginState.get();
    Activity topActivity = GlobalStore.get().topActivity.get();

    if (plugin != null && plugin.getId() != null) {
      RequestBody body = RequestUtils.form()
          .set(Const.TRACK_EVENT_KEY_EVENT, ObjectUtils.toMap(event))
          .set(Const.TRACK_EVENT_KEY_GUEST, ObjectUtils.toMap(GuestStore.get().guest))
          .create();

      Api.trackEvent(plugin.getId(), body, PushBotManager::handlePushBot)
          .cancelBy(ActionType.SHUTDOWN)
          .run(new RestSubscriber<PushBotReachRepo>() {

            @Override
            public void onError(RetrofitException error) {
              L.e("Fail to show push bot. " + error.getMessage());
            }

            @Override
            public void onSuccessWithNull() {
              L.e("There is no active push bots");
            }

            @Override
            public void onSuccess(@NonNull PushBotReachRepo pushBotReachRepo) {
              PushBotManager.doPushBotAction(pushBotReachRepo, topActivity);
            }
          });
    }
  }
}
