package com.zoyi.channel.plugin.android;


import com.zoyi.channel.plugin.android.global.Const;

public enum CHLocale {
  KOREAN(Const.KOREAN),
  JAPANESE(Const.JAPANESE),
  ENGLISH(Const.ENGLISH),
  DEVICE("device"),
  NONE("none");

  final String string;

  CHLocale(String string) {
    this.string = string;
  }

  public static CHLocale fromString(String languageCode) {
    if (languageCode == null) {
      return DEVICE;
    }
    switch (languageCode) {
      case Const.KOREAN:
        return KOREAN;
      case Const.JAPANESE:
        return JAPANESE;
      case Const.ENGLISH:
        return ENGLISH;
      case "device":
        return DEVICE;
      default:
        return NONE;
    }
  }

  @Override
  public String toString() {
    return string;
  }

  public boolean isValid() {
    return this == KOREAN || this == JAPANESE || this == ENGLISH;
  }
}
