/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Producer;

public final class ProducerArbiter
implements Producer {
    long requested;
    Producer currentProducer;
    boolean emitting;
    long missedRequested;
    long missedProduced;
    Producer missedProducer;
    static final Producer NULL_PRODUCER = new Producer(){

        public void request(long n) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (n == 0L) {
            return;
        }
        ProducerArbiter producerArbiter = this;
        synchronized (producerArbiter) {
            if (this.emitting) {
                this.missedRequested += n;
                return;
            }
            this.emitting = true;
        }
        boolean skipFinal = false;
        try {
            long r = this.requested;
            long u = r + n;
            if (u < 0L) {
                u = Long.MAX_VALUE;
            }
            this.requested = u;
            Producer p = this.currentProducer;
            if (p != null) {
                p.request(n);
            }
            this.emitLoop();
            skipFinal = true;
        }
        finally {
            if (!skipFinal) {
                ProducerArbiter producerArbiter2 = this;
                synchronized (producerArbiter2) {
                    this.emitting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produced(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("n > 0 required");
        }
        ProducerArbiter producerArbiter = this;
        synchronized (producerArbiter) {
            if (this.emitting) {
                this.missedProduced += n;
                return;
            }
            this.emitting = true;
        }
        boolean skipFinal = false;
        try {
            long r = this.requested;
            if (r != Long.MAX_VALUE) {
                long u = r - n;
                if (u < 0L) {
                    throw new IllegalStateException("more items arrived than were requested");
                }
                this.requested = u;
            }
            this.emitLoop();
            skipFinal = true;
        }
        finally {
            if (!skipFinal) {
                ProducerArbiter producerArbiter2 = this;
                synchronized (producerArbiter2) {
                    this.emitting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProducer(Producer newProducer) {
        ProducerArbiter producerArbiter = this;
        synchronized (producerArbiter) {
            if (this.emitting) {
                this.missedProducer = newProducer == null ? NULL_PRODUCER : newProducer;
                return;
            }
            this.emitting = true;
        }
        boolean skipFinal = false;
        try {
            this.currentProducer = newProducer;
            if (newProducer != null) {
                newProducer.request(this.requested);
            }
            this.emitLoop();
            skipFinal = true;
        }
        finally {
            if (!skipFinal) {
                ProducerArbiter producerArbiter2 = this;
                synchronized (producerArbiter2) {
                    this.emitting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitLoop() {
        while (true) {
            Producer localProducer;
            long localProduced;
            long localRequested;
            ProducerArbiter producerArbiter = this;
            synchronized (producerArbiter) {
                localRequested = this.missedRequested;
                localProduced = this.missedProduced;
                localProducer = this.missedProducer;
                if (localRequested == 0L && localProduced == 0L && localProducer == null) {
                    this.emitting = false;
                    return;
                }
                this.missedRequested = 0L;
                this.missedProduced = 0L;
                this.missedProducer = null;
            }
            long r = this.requested;
            if (r != Long.MAX_VALUE) {
                long u = r + localRequested;
                if (u < 0L || u == Long.MAX_VALUE) {
                    this.requested = r = Long.MAX_VALUE;
                } else {
                    long v = u - localProduced;
                    if (v < 0L) {
                        throw new IllegalStateException("more produced than requested");
                    }
                    r = v;
                    this.requested = v;
                }
            }
            if (localProducer != null) {
                if (localProducer == NULL_PRODUCER) {
                    this.currentProducer = null;
                    continue;
                }
                this.currentProducer = localProducer;
                localProducer.request(r);
                continue;
            }
            Producer p = this.currentProducer;
            if (p == null || localRequested == 0L) continue;
            p.request(localRequested);
        }
    }
}

