/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.wrapper.ChannelWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.EventRepo;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ManagersWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessengersRepo;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ProfileBotSchemasRepo;
import com.zoyi.channel.plugin.android.model.wrapper.PushBotReachRepo;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.DELETE;
import com.zoyi.retrofit2.http.Field;
import com.zoyi.retrofit2.http.FormUrlEncoded;
import com.zoyi.retrofit2.http.GET;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.retrofit2.http.HeaderMap;
import com.zoyi.retrofit2.http.Headers;
import com.zoyi.retrofit2.http.Multipart;
import com.zoyi.retrofit2.http.POST;
import com.zoyi.retrofit2.http.PUT;
import com.zoyi.retrofit2.http.Part;
import com.zoyi.retrofit2.http.Path;
import com.zoyi.retrofit2.http.Query;
import com.zoyi.rx.Observable;
import java.util.List;
import java.util.Map;

public interface ChannelApi {
    @GET(value="packages/{packageId}/versions/latest")
    public Observable<PackageWrapper> getLastestPackage(@Path(value="packageId") String var1, @Query(value="from") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/plugins/{key}/boot/v2")
    public Observable<PluginWrapper> bootV2(@HeaderMap Map<String, String> var1, @Body RequestBody var2, @Path(value="key") @Nullable String var3);

    @GET(value="/app/plugins/{pluginId}")
    public Observable<PluginWrapper> getPlugin(@Path(value="pluginId") String var1);

    @GET(value="/app/channels")
    public Observable<ChannelWrapper> getChannel();

    @POST(value="/app/guests/touch")
    public Observable<GuestWrapper> touch();

    @POST(value="/app/guests/touch")
    public Observable<GuestWrapper> touch(@Header(value="Accept-Language") String var1);

    @GET(value="/app/user_chats")
    public Observable<UserChatsWrapper> getUserChats(@Query(value="sortField") String var1, @Query(value="sortOrder") String var2, @Query(value="limit") Integer var3, @Query(value="includeClosed") boolean var4);

    @GET(value="/app/user_chats/{userChatId}")
    public Observable<UserChatWrapper> getUserChat(@Path(value="userChatId") String var1);

    @GET(value="/app/user_chats/{userChatId}/messages")
    public Observable<MessagesWrapper> getMessages(@Path(value="userChatId") String var1, @Query(value="since") String var2, @Query(value="limit") Integer var3, @Query(value="sortOrder") String var4);

    @POST(value="/app/plugins/{pluginId}/user_chats")
    public Observable<UserChatWrapper> createUserChat(@Path(value="pluginId") String var1);

    @PUT(value="/app/user_chats/{userChatId}/messages/read")
    public Observable<Void> read(@Path(value="userChatId") String var1);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/user_chats/{userChatId}/messages")
    public Observable<MessageWrapper> sendMessage(@Path(value="userChatId") String var1, @Body RequestBody var2);

    @Multipart
    @POST(value="/app/user_chats/{userChatId}/messages/file")
    public Observable<MessageWrapper> uploadFile(@Path(value="userChatId") String var1, @Part MultipartBody.Part var2, @Part(value="requestId") RequestBody var3);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="app/device_tokens")
    public Observable<Void> sendToken(@Body RequestBody var1);

    @Headers(value={"Content-Type: application/json"})
    @DELETE(value="app/device_tokens/{platform}/{key}")
    public Observable<Void> deleteToken(@Header(value="X-Guest-Jwt") String var1, @Path(value="platform") String var2, @Path(value="key") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="app/user_chats/{userChatId}/remove")
    public Observable<Void> removeUserChat(@Path(value="userChatId") String var1);

    @PUT(value="app/user_chats/{userChatId}/close")
    public Observable<MessageWrapper> closeUserChat(@Path(value="userChatId") String var1, @Query(value="formId") @Nullable String var2, @Query(value="requestId") String var3);

    @FormUrlEncoded
    @PUT(value="app/user_chats/{userChatId}/review")
    public Observable<MessageWrapper> reviewUserChat(@Path(value="userChatId") String var1, @Query(value="formId") @Nullable String var2, @Field(value="review") String var3, @Query(value="requestId") String var4);

    @GET(value="/available/countries")
    public Observable<List<Country>> getCountries();

    @POST(value="/app/plugins/{pluginId}/events/v2")
    public Observable<EventRepo> trackEvent(@Path(value="pluginId") String var1, @Body RequestBody var2);

    @GET(value="/app/channels/operators")
    public Observable<ManagersWrapper> getOperators();

    @POST(value="/app/user_chats/{userChatId}/plugins/{pluginId}/profile_bot")
    public Observable<Void> requestProfileBot(@Path(value="userChatId") String var1, @Path(value="pluginId") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/messages/{messageId}/profile_bot")
    public Observable<MessageWrapper> updateProfileBot(@Path(value="messageId") String var1, @Body RequestBody var2);

    @GET(value="app/messages/{messageId}/translate")
    public Observable<TranslationRepo> getTranslatedMessage(@Path(value="messageId") String var1, @Query(value="language") String var2);

    @GET(value="/app/plugins/{pluginId}/support_bot")
    public Observable<SupportBotEntry> getSupportBot(@Path(value="pluginId") String var1);

    @POST(value="app/support_bots/{supportBotId}/user_chats")
    public Observable<UserChatWrapper> createSupportBotUserChat(@Path(value="supportBotId") String var1);

    @POST(value="/app/user_chats/{userChatId}/support_bot/buttons/{buttonId}")
    public Observable<MessageWrapper> submitButtonAction(@Path(value="userChatId") String var1, @Path(value="buttonId") @Nullable String var2, @Query(value="actionId") @Nullable String var3, @Query(value="requestId") @Nullable String var4);

    @PUT(value="app/user_chats/{userChatId}/messages/receive")
    public Observable<Void> receivePushNotification(@Path(value="userChatId") String var1);

    @POST(value="/app/nudges/{pushBotId}/reach")
    public Observable<PushBotReachRepo> reachPushBot(@Path(value="pushBotId") String var1);

    @POST(value="/app/nudges/{pushBotId}/user_chats")
    public Observable<UserChatWrapper> createPushBotUserChat(@Path(value="pushBotId") String var1);

    @POST(value="/app/user_chats/{userChatId}/nudge/keep")
    public Observable<MessageWrapper> keepPushBot(@Path(value="userChatId") String var1);

    @GET(value="/app/plugins/{pluginId}/profile_bot_schemas")
    public Observable<ProfileBotSchemasRepo> getProfileBotSchemas(@Path(value="pluginId") String var1);

    @PUT(value="/app/guests")
    public Observable<GuestWrapper> updateGuest(@Body RequestBody var1);

    @GET(value="/app/channels/messengers")
    public Observable<MessengersRepo> getMessengers();
}

