/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ConnectableMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;

public class SendingMessageItem
extends ConnectableMessageItem
implements MessageItem {
    @Nullable
    private String chatId;
    @NonNull
    private String requestId;
    @Nullable
    private String text;
    @Nullable
    private String filePath;
    @Nullable
    private String actionType;
    @Nullable
    private ActionButton actionButton;
    @NonNull
    private ContentType contentType;
    @NonNull
    private SendingState sendingState;
    private boolean isFailToSend;
    private Long createdAt = TimeUtils.getCurrentTime();

    @Nullable
    public static SendingMessageItem createDummy(@Nullable String requestId) {
        if (requestId == null) {
            return null;
        }
        SendingMessageItem item = new SendingMessageItem();
        item.requestId = requestId;
        try {
            item.createdAt = Long.parseLong(requestId.substring(0, 13));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    @NonNull
    public static SendingMessageItem copyContentFrom(@Nullable SendingMessageItem item) {
        if (item != null) {
            return new SendingMessageItem(item);
        }
        return new SendingMessageItem();
    }

    private SendingMessageItem() {
        this.requestId = "";
        this.contentType = ContentType.NONE;
        this.sendingState = SendingState.WAITING;
    }

    public SendingMessageItem(@Nullable String chatId) {
        this.requestId = this.createdAt + Utils.getRandomString(4);
        this.chatId = chatId;
        this.isFailToSend = false;
        this.contentType = ContentType.NONE;
        this.sendingState = SendingState.WAITING;
    }

    private SendingMessageItem(@NonNull SendingMessageItem item) {
        this.requestId = this.createdAt + Utils.getRandomString(4);
        this.chatId = item.getChatId();
        this.text = item.getText();
        this.filePath = item.getFilePath();
        this.actionType = item.getActionType();
        this.actionButton = item.getActionButton();
        this.contentType = item.getContentType();
        this.isFailToSend = false;
        this.sendingState = SendingState.WAITING;
    }

    @Override
    public Long getPrimaryKey() {
        return this.createdAt * 10L;
    }

    @Override
    public String getSecondaryKey() {
        return this.requestId;
    }

    @NonNull
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public MessageType getType() {
        return MessageType.SENDING;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @Override
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    @NonNull
    public SendingState getSendingState() {
        return this.sendingState;
    }

    public void setSendingState(@NonNull SendingState sendingState) {
        this.sendingState = sendingState;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public SendingMessageItem setText(@Nullable String text) {
        if (text != null) {
            this.text = text;
            this.contentType = ContentType.TEXT;
        }
        return this;
    }

    @Nullable
    public String getFilePath() {
        return this.filePath;
    }

    public SendingMessageItem setFilePath(@Nullable String filePath) {
        if (filePath != null) {
            this.filePath = filePath;
            this.contentType = ContentType.FILE;
        }
        return this;
    }

    @Nullable
    public String getActionType() {
        return this.actionType;
    }

    @Nullable
    public ActionButton getActionButton() {
        return this.actionButton;
    }

    public SendingMessageItem setActionBundle(@NonNull String actionType, @Nullable ActionButton actionButton) {
        this.actionType = actionType;
        this.actionButton = actionButton;
        this.contentType = ContentType.ACTION;
        return this;
    }

    public void updateMessageOnActionInput(@NonNull Message message) {
        if (this.contentType == ContentType.ACTION && this.actionButton != null) {
            this.actionButton.setMessage(message);
        }
    }

    @Override
    public boolean isSamePerson(@NonNull ConnectableMessageItem item) {
        if (item instanceof SendingMessageItem) {
            return true;
        }
        if (item instanceof ChatMessageItem) {
            return ((ChatMessageItem)item).getType() == MessageType.GUEST;
        }
        return false;
    }
}

