package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.TranslationStore;
import com.zoyi.rx.functions.Action0;

public class TranslateAction {

  public static void translate(Message message, Action0 onComplete) {
    Api.getTranslatedMessage(message.getId(), SettingsStore.get().locale.get().toString())
        .cancelBy(ActionType.CHAT_CLOSED, ActionType.SHUTDOWN)
        .run(new RestSubscriber<TranslationRepo>() {
          @Override
          public void onError(RetrofitException error) {
            TranslationStore.get().translation.removeByKey(message.getId());
            onComplete.call();
          }

          @Override
          public void onSuccess(@NonNull TranslationRepo repo) {
            TranslationStore.get().translation.upsert(
                new TranslationInfo(message.getId(), repo.getTranslatedMessage(), TranslationState.TRANSLATED)
            );

            onComplete.call();
          }
        });
  }
}
