package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by jerry on 2018. 9. 7..
 */

public class ChannelApiManager {

  private static Map<String, Subscriber<?>> subscribers = new ConcurrentHashMap<>();

  @Nullable
  private static ChannelApi channelApi;

  public static ChannelApi get() {
    if (channelApi == null) {
      channelApi = ServiceFactory.create();
    }
    return channelApi;
  }

  public static <E> void call(Observable<E> observable, Subscriber<E> subscriber) {
    observable
        .onBackpressureBuffer()
        .subscribeOn(Schedulers.io())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(subscriber);
  }

  public static <E> void callOnce(String tag, Observable<E> observable, Subscriber<E> subscriber) {
    cancel(tag);

    subscribers.put(tag, subscriber);
    call(observable, subscriber);
  }

  public static void cancel(String tag) {
    Subscriber<?> subscriber = subscribers.get(tag);

    if (subscriber != null && !subscriber.isUnsubscribed()) {
      subscriber.unsubscribe();
    }
  }

  public static boolean isRunning(String tag) {
    Subscriber<?> subscriber = subscribers.get(tag);

    return subscriber != null && !subscriber.isUnsubscribed();
  }
}
