/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.adapter.rxjava;

import com.zoyi.retrofit2.Response;
import com.zoyi.retrofit2.adapter.rxjava.HttpException;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnCompletedFailedException;
import com.zoyi.rx.exceptions.OnErrorFailedException;
import com.zoyi.rx.exceptions.OnErrorNotImplementedException;
import com.zoyi.rx.plugins.RxJavaPlugins;

final class BodyOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private final Observable.OnSubscribe<Response<T>> upstream;

    BodyOnSubscribe(Observable.OnSubscribe<Response<T>> upstream) {
        this.upstream = upstream;
    }

    public void call(Subscriber<? super T> subscriber) {
        this.upstream.call(new BodySubscriber<T>(subscriber));
    }

    private static class BodySubscriber<R>
    extends Subscriber<Response<R>> {
        private final Subscriber<? super R> subscriber;
        private boolean subscriberTerminated;

        BodySubscriber(Subscriber<? super R> subscriber) {
            super(subscriber);
            this.subscriber = subscriber;
        }

        public void onNext(Response<R> response) {
            if (response.isSuccessful()) {
                this.subscriber.onNext(response.body());
            } else {
                this.subscriberTerminated = true;
                HttpException t = new HttpException(response);
                try {
                    this.subscriber.onError((Throwable)((Object)t));
                }
                catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal((Throwable)inner);
                    CompositeException composite = new CompositeException(new Throwable[]{t, inner});
                    RxJavaPlugins.getInstance().getErrorHandler().handleError((Throwable)composite);
                }
            }
        }

        public void onError(Throwable throwable) {
            if (!this.subscriberTerminated) {
                this.subscriber.onError(throwable);
            } else {
                AssertionError broken = new AssertionError((Object)"This should never happen! Report as a Retrofit bug with the full stacktrace.");
                ((Throwable)((Object)broken)).initCause(throwable);
                RxJavaPlugins.getInstance().getErrorHandler().handleError((Throwable)((Object)broken));
            }
        }

        public void onCompleted() {
            if (!this.subscriberTerminated) {
                this.subscriber.onCompleted();
            }
        }
    }
}

