/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.functions.Action0;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleDelay<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;

    public SingleDelay(Single.OnSubscribe<T> source, long delay, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
        this.delay = delay;
        this.unit = unit;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        Scheduler.Worker w = this.scheduler.createWorker();
        ObserveOnSingleSubscriber<? super T> parent = new ObserveOnSingleSubscriber<T>(t, w, this.delay, this.unit);
        t.add(w);
        t.add(parent);
        this.source.call(parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObserveOnSingleSubscriber<T>
    extends SingleSubscriber<T>
    implements Action0 {
        final SingleSubscriber<? super T> actual;
        final Scheduler.Worker w;
        final long delay;
        final TimeUnit unit;
        T value;
        Throwable error;

        public ObserveOnSingleSubscriber(SingleSubscriber<? super T> actual, Scheduler.Worker w, long delay, TimeUnit unit) {
            this.actual = actual;
            this.w = w;
            this.delay = delay;
            this.unit = unit;
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.w.schedule(this, this.delay, this.unit);
        }

        @Override
        public void onError(Throwable error) {
            this.error = error;
            this.w.schedule(this, this.delay, this.unit);
        }

        @Override
        public void call() {
            try {
                Throwable ex = this.error;
                if (ex != null) {
                    this.error = null;
                    this.actual.onError(ex);
                } else {
                    T v = this.value;
                    this.value = null;
                    this.actual.onSuccess(v);
                }
            }
            finally {
                this.w.unsubscribe();
            }
        }
    }
}

