/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat3.listener.MessageActionListener;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.store2.TypingStore;
import com.zoyi.channel.plugin.android.store2.TypingTextSaveStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ChatInputView
extends LinearLayout {
    private Context context;
    private View viewChatBlocked;
    private View layoutChatInput;
    private View buttonAttach;
    private WatchedEditText editChat;
    private View buttonSend;
    @Nullable
    private String userChatId;
    @Nullable
    private MessageActionListener messageActionListener;

    public ChatInputView(Context context) {
        super(context);
        this.init(context);
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_chat_input, (ViewGroup)this, true);
        this.viewChatBlocked = view.findViewById(R.id.viewChatBlocked);
        this.layoutChatInput = view.findViewById(R.id.layoutChatInput);
        this.buttonAttach = view.findViewById(R.id.buttonChatAttach);
        this.buttonAttach.setOnClickListener(v -> {
            if (this.messageActionListener != null) {
                this.messageActionListener.onAttachmentButtonClick();
            }
        });
        this.editChat = (WatchedEditText)view.findViewById(R.id.editChat);
        this.buttonSend = view.findViewById(R.id.buttonChatSend);
        this.buttonSend.setEnabled(true);
        this.buttonSend.setOnClickListener(v -> {
            String newString = StringUtils.stripEnd(this.editChat.getString(), null);
            if (this.messageActionListener != null && !TextUtils.isEmpty((CharSequence)newString)) {
                this.messageActionListener.onSendClick(newString);
            }
            this.editChat.setText("");
        });
        this.editChat.setWatchedTextChangedListener(s -> {
            boolean isEnabled;
            TypingStore.get().typingState.set(!TextUtils.isEmpty((CharSequence)s));
            if (TextUtils.isEmpty((CharSequence)s)) {
                TypingStore.get().myTypingState.remove(Typing.dummy());
            } else {
                TypingStore.get().myTypingState.upsert(Typing.dummy());
            }
            String newString = StringUtils.stripEnd(s, null);
            boolean bl = isEnabled = !TextUtils.isEmpty((CharSequence)newString);
            if (isEnabled != this.buttonSend.isEnabled()) {
                this.buttonSend.setEnabled(isEnabled);
            }
            if (this.userChatId != null) {
                TypingTextSaveStore.get().savedTexts.upsert((Pair<String, String>)new Pair((Object)this.userChatId, (Object)s));
            }
        });
        this.editChat.setOnFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                this.setInputDim(false);
            }
        });
        this.setEnabled(false);
    }

    public void initUserChat(String userChatId) {
        if (this.userChatId == null) {
            this.userChatId = userChatId;
            Pair<String, String> pair = TypingTextSaveStore.get().savedTexts.get(userChatId);
            if (pair != null && pair.second != null) {
                this.editChat.setText((CharSequence)pair.second);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        TypingStore.get().typingState.set(false);
    }

    public void setMessageActionListener(@Nullable MessageActionListener messageActionListener) {
        this.messageActionListener = messageActionListener;
    }

    public void setInputDim(boolean enabled) {
        this.layoutChatInput.setBackgroundColor(ResUtils.getColor(enabled ? R.color.ch_snow : R.color.ch_white));
    }

    public EditText getEditText() {
        return this.editChat;
    }

    public void setEnabled(boolean enabled) {
        this.viewChatBlocked.setVisibility(enabled ? 8 : 0);
        this.layoutChatInput.setVisibility(enabled ? 0 : 8);
    }

    public void setFocus() {
        this.editChat.requestFocus();
    }

    public void setVisibility(int visibility) {
        if (this.getVisibility() != visibility) {
            super.setVisibility(visibility);
        }
    }
}

