/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.action.GuestAction;
import com.zoyi.channel.plugin.android.action.PluginAction;
import com.zoyi.channel.plugin.android.action.PushBotAction;
import com.zoyi.channel.plugin.android.action.SupportBotAction;
import com.zoyi.channel.plugin.android.action.TranslateAction;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.PushBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat3.contract.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat3.contract.ChatContract;
import com.zoyi.channel.plugin.android.activity.chat3.listener.MessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat3.manager.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat3.manager.chat.ChatManagerImpl;
import com.zoyi.channel.plugin.android.activity.chat3.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector2.ChannelSelector;
import com.zoyi.channel.plugin.android.selector2.ChatSelector;
import com.zoyi.channel.plugin.android.selector2.MessageSelector;
import com.zoyi.channel.plugin.android.selector2.ProfileBotSelector;
import com.zoyi.channel.plugin.android.selector2.ProfileSelector;
import com.zoyi.channel.plugin.android.selector2.SocketSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store2.ChatStore;
import com.zoyi.channel.plugin.android.store2.CountryStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.ProfileBotStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.TranslationStore;
import com.zoyi.channel.plugin.android.store2.TypingStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import com.zoyi.rx.functions.Action3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChatPresenter
extends AbstractAdapterPresenter<ChatContract.View, ChatAdapterContract.View, ChatAdapterContract.Model>
implements ChatContract.Presenter,
MessageSendListener {
    private ChatContentType contentType;
    @Nullable
    private String contentId;
    @Nullable
    private Binder welcomeBinder;
    @Nullable
    private Binder welcomeAcceptInputBinder;
    @Nullable
    private Subscription joinSubscription;
    @Nullable
    private UserChat userChat;
    @Nullable
    private Session lastReadSession;
    @Nullable
    private List<SendingMessageItem> tempItems;

    public ChatPresenter(ChatContract.View view, ChatAdapterContract.View adapterView, ChatAdapterContract.Model adapterModel, ChatContentType contentType, @Nullable String contentId) {
        super(view, adapterView, adapterModel);
        this.contentType = contentType;
        this.contentId = contentId;
    }

    private ChatManagerImpl getChatManager() {
        return ChatManager.get(this.contentType == ChatContentType.USER_CHAT ? this.contentId : null);
    }

    @Override
    public void init() {
        switch (this.contentType) {
            case USER_CHAT: {
                ((ChatContract.View)this.view).onFetchStateChange(FetchState.LOADING);
                if (this.contentId == null) break;
                this.bindUserChatEventReceiver();
                break;
            }
            case PUSH_BOT_CHAT: {
                this.tempItems = new ArrayList<SendingMessageItem>();
                PushBotItem pushBotItem = (PushBotItem)PushBotStore.get().pushBots.get(this.contentId);
                if (pushBotItem != null) {
                    pushBotItem.read();
                    PushBotStore.get().pushBots.upsert(pushBotItem);
                    ((ChatAdapterContract.Model)this.adapterModel).setInitMessage(new PushBotMessageItem(pushBotItem));
                    ((ChatContract.View)this.view).onWelcomeStateChange(ChatContentType.PUSH_BOT_CHAT, false);
                    ((ChatContract.View)this.view).onFetchStateChange(FetchState.COMPLETE);
                    break;
                }
                ((ChatContract.View)this.view).onFetchStateChange(FetchState.FAILED);
                break;
            }
            case NONE: {
                this.tempItems = new ArrayList<SendingMessageItem>();
                ((ChatContract.View)this.view).onFetchStateChange(FetchState.LOADING);
                Plugin plugin = PluginStore.get().pluginState.get();
                if (plugin == null || plugin.getId() == null) break;
                this.bindWelcomeMessage();
                PluginAction.fetchPlugin(plugin.getId(), false);
                SupportBotAction.fetchSupportBot(plugin.getId(), false);
            }
        }
    }

    @Override
    protected void handleAction(ActionType actionType) {
        switch (actionType) {
            case SOCKET_DISCONNECTED: 
            case SHUTDOWN: {
                ChatStore.get().messages.clear();
                ChatStore.get().backwardId.set(null);
            }
        }
    }

    private void bindWelcomeMessage() {
        this.welcomeBinder = ChatSelector.bindWelcomeMessage((Action3<FetchState, SupportBotEntry, String>)((Action3)(fetchState, supportBotEntry, welcomeMessage) -> {
            switch (fetchState) {
                case FAILED: {
                    ((ChatContract.View)this.view).onFetchStateChange(FetchState.FAILED);
                    break;
                }
                case COMPLETE: {
                    if (supportBotEntry != null) {
                        this.contentType = ChatContentType.SUPPORT_BOT_CHAT;
                        this.contentId = supportBotEntry.getId();
                        ((ChatAdapterContract.Model)this.adapterModel).setInitMessage(new SupportBotMessageItem((SupportBotEntry)supportBotEntry));
                        ((ChatContract.View)this.view).onWelcomeStateChange(ChatContentType.SUPPORT_BOT_CHAT, false);
                        ((ChatContract.View)this.view).onFetchStateChange(FetchState.COMPLETE);
                    } else if (welcomeMessage != null) {
                        ((ChatAdapterContract.Model)this.adapterModel).setInitMessage(new WelcomeMessageItem((String)welcomeMessage));
                        this.bindWelcomeAcceptInput();
                        ((ChatContract.View)this.view).onFetchStateChange(FetchState.COMPLETE);
                    } else {
                        ((ChatContract.View)this.view).onFetchStateChange(FetchState.FAILED);
                    }
                    if (this.welcomeBinder == null) break;
                    this.welcomeBinder.unbind();
                }
            }
        }));
    }

    private void bindWelcomeAcceptInput() {
        if (this.welcomeAcceptInputBinder == null) {
            this.welcomeAcceptInputBinder = ChannelSelector.bindAcceptAction((Action1<Boolean>)((Action1)acceptInput -> ((ChatContract.View)this.view).onWelcomeStateChange(ChatContentType.NONE, (boolean)acceptInput)));
        }
    }

    private void createUserChat() {
        if (this.contentType == ChatContentType.NONE && !Api.isRunning(ActionType.CREATE_USER_CHAT)) {
            String pluginId;
            Plugin plugin = PluginStore.get().pluginState.get();
            String string2 = pluginId = plugin != null ? plugin.getId() : null;
            if (pluginId != null) {
                ChatAction.createUserChat(pluginId, new RestSubscriber<UserChatWrapper>(){

                    @Override
                    public void onError(RetrofitException error) {
                        ChatPresenter.this.setTempSendingItemsFail();
                    }

                    @Override
                    public void onSuccess(@NonNull UserChatWrapper repo) {
                        repo.update();
                        ChatPresenter.this.handleUserChatInit(repo.getUserChat(), repo.getMessage());
                    }
                });
            }
        }
    }

    @Override
    public void createPushBotChat() {
        if (this.contentType == ChatContentType.PUSH_BOT_CHAT && !Api.isRunning(ActionType.CREATE_USER_CHAT)) {
            final String pushBotId = this.contentId;
            ((ChatContract.View)this.view).setPushBotSaveButtonVisibility(false);
            final SendingMessageItem pushBotMessageItem = new SendingMessageItem(null);
            pushBotMessageItem.setActionBundle("keepPushBot", null);
            pushBotMessageItem.setText(":+1:");
            this.addTempSendingItem(pushBotMessageItem);
            PushBotAction.createPushBotUserChat(pushBotId, new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ((ChatContract.View)ChatPresenter.this.view).setPushBotSaveButtonVisibility(true);
                    ChatPresenter.this.removeTempSendingItem(pushBotMessageItem);
                }

                @Override
                public void onSuccess(@NonNull UserChatWrapper repo) {
                    repo.update();
                    PushBotItem item = (PushBotItem)PushBotStore.get().pushBots.get(pushBotId);
                    if (item != null) {
                        item.remove();
                        PushBotStore.get().pushBots.upsert(item);
                    }
                    ChatPresenter.this.handleUserChatInit(repo.getUserChat(), repo.getMessage());
                }
            });
        }
    }

    private void createSupportBotUserChat(final SendingMessageItem item) {
        if (this.contentType == ChatContentType.SUPPORT_BOT_CHAT && !Api.isRunning(ActionType.CREATE_USER_CHAT)) {
            String supportBotId = this.contentId;
            this.addTempSendingItem(item);
            SupportBotAction.createSupportBotUserChat(supportBotId, new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter.this.removeTempSendingItem(item);
                }

                @Override
                public void onSuccess(@NonNull UserChatWrapper repo) {
                    repo.update();
                    item.updateMessageOnActionInput(repo.getMessage());
                    ChatPresenter.this.handleUserChatInit(repo.getUserChat(), repo.getMessage());
                }
            });
        }
    }

    private void addTempSendingItem(SendingMessageItem item) {
        if (item != null) {
            this.addTempSendingItems(Collections.singleton(item));
        }
    }

    private void addTempSendingItems(Collection<SendingMessageItem> items) {
        if (this.tempItems != null && items != null && items.size() > 0) {
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItems(items);
            this.tempItems.addAll(items);
        }
    }

    private boolean removeTempSendingItem(SendingMessageItem item) {
        if (this.tempItems != null && item != null) {
            ((ChatAdapterContract.Model)this.adapterModel).removeMessageItem(item);
            return this.tempItems.remove(item);
        }
        return false;
    }

    private void setTempSendingItemsChatId(String chatId) {
        if (this.tempItems != null) {
            for (SendingMessageItem item : this.tempItems) {
                item.setChatId(chatId);
            }
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItems(this.tempItems);
        }
    }

    private void setTempSendingItemsFail() {
        if (this.tempItems != null) {
            for (SendingMessageItem item : this.tempItems) {
                item.setSendingState(SendingState.FAIL);
            }
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItems(this.tempItems);
        }
    }

    private void handleUserChatInit(UserChat userChat, Message message) {
        if (this.welcomeBinder != null) {
            this.welcomeBinder.unbind();
            this.welcomeBinder = null;
        }
        if (this.welcomeAcceptInputBinder != null) {
            this.welcomeAcceptInputBinder.unbind();
            this.welcomeAcceptInputBinder = null;
        }
        if (userChat != null && userChat.getId() != null) {
            this.userChat = userChat;
            this.contentType = ChatContentType.USER_CHAT;
            this.contentId = userChat.getId();
            ((ChatAdapterContract.Model)this.adapterModel).replaceInitMessageItem(message);
            this.setTempSendingItemsChatId(userChat.getId());
            ChatStore.get().messages.attachChatId(this.contentId);
            this.bindUserChatEventReceiver();
        }
    }

    private void bindUserChatEventReceiver() {
        if (this.joinSubscription == null && this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            this.getChatManager().attachListener(this);
            this.bind(SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
                if (socketStatus == SocketStatus.READY) {
                    this.fetchUserChat();
                }
            })));
            this.bind(ChatSelector.bindChat(this.contentId, (Action3<UserChat, Boolean, Boolean>)((Action3)(userChat, acceptInput, temporaryInputOpened) -> {
                if (temporaryInputOpened.booleanValue() && !"solved".equals(userChat.getState())) {
                    ChatStore.get().temporaryInputOpenedState.set(false);
                }
                ChatAction.read(this.contentId);
                this.userChat = userChat;
                ((ChatContract.View)this.view).onChatStateChange((UserChat)userChat, (boolean)acceptInput, (boolean)temporaryInputOpened);
            })));
            this.bind(ProfileBotSelector.bindProfileBotActivation((Action1<Boolean>)((Action1)isActivated -> {
                if (isActivated.booleanValue()) {
                    ((ChatContract.View)this.view).setInputDim(true);
                }
            })));
            this.bind(ChatSelector.bindTyping((Action1<Boolean>)((Action1)isTyping -> SocketManager.typing(Typing.create(isTyping != false ? "start" : "stop", this.contentId)))));
            this.bind(ChatSelector.bindHostTyping(this.contentId, (Action1<List<Typing>>)((Action1)typings -> ((ChatAdapterContract.Model)this.adapterModel).setTypings((List<Typing>)typings))));
            this.bind(MessageSelector.bindMessages((Action2<Collection<Message>, Collection<Message>>)((Action2)(initMessages, upsertMessages) -> {
                if (initMessages != null) {
                    if (this.tempItems != null && this.tempItems.size() > 0) {
                        this.getChatManager().send(this.tempItems);
                        this.tempItems.clear();
                        this.tempItems = null;
                    }
                    ((ChatAdapterContract.Model)this.adapterModel).setMessages((Collection<Message>)initMessages, (Collection<SendingMessageItem>)this.getChatManager().getUnsentItems(), this.lastReadSession);
                    ((ChatContract.View)this.view).scrollToBottom();
                    ((ChatContract.View)this.view).onFetchStateChange(FetchState.COMPLETE);
                    ChatAction.read(this.contentId);
                } else if (upsertMessages != null) {
                    ProfileEntity profileEntity;
                    Message message;
                    boolean isScrollOnBottom = ((ChatContract.View)this.view).isScrollOnBottom();
                    Long lastKey = ((ChatAdapterContract.Model)this.adapterModel).getLastMessageItemKey();
                    ((ChatAdapterContract.Model)this.adapterModel).addMessages((Collection<Message>)upsertMessages, this.lastReadSession);
                    Long newLastKey = ((ChatAdapterContract.Model)this.adapterModel).getLastMessageItemKey();
                    if (isScrollOnBottom) {
                        ((ChatContract.View)this.view).scrollToBottom();
                    } else if (lastKey != null && newLastKey != null && lastKey < newLastKey && (message = ((ChatAdapterContract.Model)this.adapterModel).getLastMessage()) != null && (profileEntity = ProfileSelector.getProfile(message.getPersonType(), message.getPersonId())) != null) {
                        ((ChatContract.View)this.view).showNewMessageAlert(profileEntity);
                    }
                }
            })));
            this.joinSubscription = SocketManager.observable().subscribe(joinedChatId -> {
                if (this.contentId != null && this.contentId.equals(joinedChatId)) {
                    ChatStore.get().messages.attachChatId(this.contentId);
                    this.fetchInitMessages();
                }
            });
        }
    }

    private void fetchUserChat() {
        ChatAction.fetchUserChat(this.contentId, new RestSubscriber<UserChatWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ((ChatContract.View)ChatPresenter.this.view).onFetchStateChange(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull UserChatWrapper repo) {
                repo.update();
                ChatStore.get().messages.clear();
                ChatStore.get().backwardId.set(null);
                ChatPresenter.this.lastReadSession = repo.getSession();
                SocketManager.joinChat(repo.getUserChat().getId());
            }
        });
    }

    private void fetchInitMessages() {
        ChatAction.fetchMessages(this.contentId, new RestSubscriber<MessagesWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                SocketManager.leaveChat(ChatPresenter.this.contentId);
                ((ChatContract.View)ChatPresenter.this.view).onFetchStateChange(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull MessagesWrapper repo) {
                repo.update();
                ChatStore.get().messages.set(repo.getMessages());
                ChatStore.get().backwardId.set(repo.getNext());
            }
        });
    }

    @Override
    public void fetchBackwardMessages() {
        String backwardId = ChatStore.get().backwardId.get();
        if (!Api.isRunning(ActionType.FETCH_BACKWARD_MESSAGES) && backwardId != null) {
            ChatAction.fetchBackwardMessages(this.contentId, backwardId, new RestSubscriber<MessagesWrapper>(){

                @Override
                public void onSuccess(@NonNull MessagesWrapper repo) {
                    repo.update();
                    ChatStore.get().messages.add(repo.getMessages());
                    ChatStore.get().backwardId.set(repo.getNext());
                }
            });
        }
    }

    @Override
    public void sendText(String message) {
        if (this.tempItems != null) {
            this.addTempSendingItem(new SendingMessageItem(null).setText(message));
            this.createUserChat();
        } else if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            SendingMessageItem item = new SendingMessageItem(this.contentId).setText(message);
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
            this.getChatManager().send(item);
        }
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void uploadFiles(ArrayList<String> paths) {
        String chatId;
        String string2 = chatId = this.contentType == ChatContentType.USER_CHAT ? this.contentId : null;
        if (paths != null && paths.size() > 0) {
            ArrayList<SendingMessageItem> items = new ArrayList<SendingMessageItem>();
            for (String filePath : paths) {
                if (filePath == null) continue;
                items.add(new SendingMessageItem(chatId).setFilePath(filePath));
            }
            if (this.tempItems != null) {
                this.addTempSendingItems(items);
                this.createUserChat();
            } else if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
                ((ChatAdapterContract.Model)this.adapterModel).addMessageItems(items);
                this.getChatManager().send(items);
            }
            ((ChatContract.View)this.view).scrollToBottom();
        }
    }

    @Override
    public void translate(Message message) {
        TranslationInfo translation = (TranslationInfo)TranslationStore.get().translation.get(message.getId());
        if (translation == null) {
            TranslationStore.get().translation.upsert(TranslationInfo.createProgressStateInfo(message.getId()));
            ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
            TranslateAction.translate(message, () -> ((ChatAdapterContract.Model)this.adapterModel).addMessage(message));
        } else if (translation.getState() == TranslationState.TRANSLATED) {
            TranslationStore.get().translation.upsert(translation.setState(TranslationState.ORIGIN));
            ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
        } else if (translation.getState() == TranslationState.ORIGIN && translation.getTranslatedMessage() != null) {
            TranslationStore.get().translation.upsert(translation.setState(TranslationState.TRANSLATED));
            ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
        }
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        if (this.contentType == ChatContentType.SUPPORT_BOT_CHAT && "supportBot".equals(actionType)) {
            this.createSupportBotUserChat(new SendingMessageItem(null).setActionBundle(actionType, actionButton));
            return;
        }
        if (CompareUtils.exists((Comparable)((Object)actionType), (Comparable[])new String[]{"userChat.solve", "userChat.close"}) && CompareUtils.isSame(actionButton.getKey(), "reopen")) {
            this.reopenChat(actionButton);
            return;
        }
        if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            SendingMessageItem messageItem = new SendingMessageItem(this.contentId).setActionBundle(actionType, actionButton);
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(messageItem);
            this.getChatManager().send(messageItem);
        }
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void resend(SendingMessageItem item) {
        if (this.tempItems != null && this.removeTempSendingItem(item)) {
            this.tempItems.add(SendingMessageItem.copyContentFrom(item));
            this.createUserChat();
        } else if (this.contentType == ChatContentType.USER_CHAT) {
            this.getChatManager().resend(item);
        }
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void removeFailedItem(SendingMessageItem item) {
        if (this.tempItems == null || !this.removeTempSendingItem(item)) {
            ((ChatAdapterContract.Model)this.adapterModel).removeMessageItem(item);
            this.getChatManager().removeFailedItem(item);
        }
    }

    @Override
    public void requestCountries(final ProfileBotMessageItem item) {
        if (ProfileBotStore.get().requestState.get() != FetchState.LOADING) {
            List<Country> countries = CountryStore.get().countries.get();
            if (countries != null) {
                ((ChatContract.View)this.view).showCountryDialog(countries, item);
            } else if (!Api.isRunning(ActionType.FETCH_COUNTRIES)) {
                CountryAction.fetchCountries(new RestSubscriber<List<Country>>(){

                    @Override
                    public void onSuccess(@NonNull List<Country> countries) {
                        CountryStore.get().countries.set(countries);
                        if (countries.size() > 0) {
                            ((ChatContract.View)ChatPresenter.this.view).showCountryDialog(countries, item);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void selectCountry(String countryCode, ProfileBotMessageItem item) {
        Object inputValue;
        if (ProfileBotStore.get().requestState.get() != FetchState.LOADING && "mobileNumber".equals(ProfileBotStore.get().inputKey.get()) && (inputValue = ProfileBotStore.get().inputValue.get()) instanceof MobileNumber) {
            ((MobileNumber)inputValue).setCountryCode(Integer.valueOf(countryCode));
            ProfileBotStore.get().inputValue.set(inputValue);
            ProfileBotStore.get().requestState.set(FetchState.COMPLETE);
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
        }
    }

    @Override
    public void updateProfile(ProfileBotMessageItem item) {
        ProfileBotStore.get().requestState.set(FetchState.LOADING);
        ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
        GuestAction.updateProfileBot(item.getMessageId(), (Action1<MessageWrapper>)((Action1)repo -> {
            ProfileBotStore.get().requestFocus.set(true);
            ProfileBotStore.get().requestState.set(FetchState.COMPLETE);
            ProfileBotStore.get().inputKey.set(null);
            ProfileBotStore.get().inputValue.set(null);
            ChatStore.get().messages.add(repo.getMessage());
        }), () -> {
            ProfileBotStore.get().requestFocus.set(true);
            ProfileBotStore.get().requestState.set(FetchState.FAILED);
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
        });
    }

    private void reopenChat(@NonNull ActionButton actionButton) {
        Message message = actionButton.getMessage();
        message.clearAction();
        ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
        ChatStore.get().temporaryInputOpenedState.set(true);
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void release() {
        super.release();
        this.getChatManager().clearListener();
        if (this.welcomeBinder != null) {
            this.welcomeBinder.unbind();
            this.welcomeBinder = null;
        }
        if (this.welcomeAcceptInputBinder != null) {
            this.welcomeAcceptInputBinder.unbind();
            this.welcomeAcceptInputBinder = null;
        }
        if (this.joinSubscription != null && !this.joinSubscription.isUnsubscribed()) {
            this.joinSubscription.unsubscribe();
            this.joinSubscription = null;
        }
        if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            SocketManager.leaveChat(this.contentId);
        }
        TypingStore.get().myTypingState.upsert(Typing.dummy());
        if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            SocketManager.typing(Typing.create("stop", this.contentId));
        }
    }

    @Override
    public void onFail(SendingMessageItem item) {
        ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
    }

    @Override
    public void onResend(SendingMessageItem newItem, SendingMessageItem oldItem) {
        ((ChatAdapterContract.Model)this.adapterModel).replaceMessageItem(newItem, oldItem);
    }
}

