/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelLauncherView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeActivity;
import com.zoyi.channel.plugin.android.enumerate.ExposureType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.model.etc.PushItem;
import com.zoyi.channel.plugin.android.push_bot.OnPushClickListener;
import com.zoyi.channel.plugin.android.selector2.GlobalSelector;
import com.zoyi.channel.plugin.android.selector2.PushSelector;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.view.popup.BannerPushView;
import com.zoyi.channel.plugin.android.view.popup.PopupPushView;
import com.zoyi.rx.functions.Action1;

class ChannelView
extends FrameLayout
implements OnPushClickListener {
    private Context context;
    private ChannelLauncherView launcherView;
    private PopupPushView popupPushView;
    private BannerPushView bannerPushView;
    @Nullable
    private Binder visibilityBinder;
    @Nullable
    private Binder launcherVisibilityBinder;
    @Nullable
    private Binder popupBinder;

    public ChannelView(Context context) {
        super(context);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this, true);
        this.launcherView = (ChannelLauncherView)view.findViewById(R.id.ch_view_launcher);
        this.popupPushView = (PopupPushView)view.findViewById(R.id.ch_view_push_popup);
        this.bannerPushView = (BannerPushView)view.findViewById(R.id.ch_view_push_banner);
        this.popupPushView.setPushBotClickListener(this);
        this.bannerPushView.setPushBotClickListener(this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.visibilityBinder = GlobalSelector.bindBootState((Action1<Boolean>)((Action1)booted -> this.setVisibility(booted != false ? 0 : 8)));
        this.launcherVisibilityBinder = GlobalSelector.bindLauncherVisibility((Action1<Boolean>)((Action1)showLauncher -> {
            if (showLauncher.booleanValue()) {
                this.launcherView.show();
            } else {
                this.launcherView.hide();
            }
        }));
        this.popupBinder = PushSelector.bindPopup(this.context, (Action1<PushItem>)((Action1)popupItem -> {
            if (popupItem != null) {
                switch (popupItem.getMobileExposureType()) {
                    case PUSH_BOT_BOTTOM_BANNER: 
                    case IN_APP_PUSH: {
                        this.popupPushView.hideView();
                        this.bannerPushView.show((PushItem)popupItem);
                        break;
                    }
                    case PUSH_BOT_POPUP: {
                        this.bannerPushView.hideView();
                        this.popupPushView.show((PushItem)popupItem);
                    }
                }
            } else {
                this.popupPushView.hideView();
                this.bannerPushView.hideView();
            }
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.visibilityBinder != null) {
            this.visibilityBinder.unbind();
        }
        if (this.launcherVisibilityBinder != null) {
            this.launcherVisibilityBinder.unbind();
        }
        if (this.popupBinder != null) {
            this.popupBinder.unbind();
        }
    }

    @Override
    public void onPushClick(ExposureType exposureType, @NonNull String pushId) {
        switch (exposureType) {
            case PUSH_BOT_BOTTOM_BANNER: 
            case PUSH_BOT_POPUP: {
                this.startPushBotChat(pushId);
                break;
            }
            case IN_APP_PUSH: {
                ChannelIO.openChat(this.context, pushId);
            }
        }
    }

    @Override
    public void onPushContentsClick(@NonNull String pushId, @Nullable String redirectUrl) {
        if (redirectUrl != null) {
            Executor.executeRedirectUrlAction(this.context, redirectUrl);
        } else {
            this.startPushBotChat(pushId);
        }
    }

    private void startPushBotChat(@NonNull String pushBotId) {
        IntentUtils.setNextActivity(this.context, LoungeActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).putExtra("chatContentType", ChatContentType.PUSH_BOT_CHAT.toString()).putExtra("chatContentId", pushBotId).startActivity();
    }
}

