package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.etc.PushItem;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.selector2.PluginSelector;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class BannerPushView extends BasePushView {

  private View viewPushBotPopupButtonContent;
  private ImageView imagePushBotPopupButtonContent;

  public BannerPushView(@NonNull Context context) {
    super(context);
  }

  public BannerPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public BannerPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected int getLayoutId() {
    return R.layout.ch_plugin_view_common;
  }

  @Override
  protected void init(Context context) {
    super.init(context);
    viewPushBotPopupButtonContent = root.findViewById(R.id.ch_view_popup_button_content);
    imagePushBotPopupButtonContent = root.findViewById(R.id.ch_image_popup_button_content);
  }

  @Override
  protected int getDefaultTextMaxLine() {
    return 2;
  }

  @Override
  protected int getAttachmentTextMaxLine() {
    return 2;
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = PluginSelector.bindPlugin(plugin -> {
      viewPushBotPopupButtonContent.setBackgroundColor(plugin.getBackgroundColor());
      imagePushBotPopupButtonContent
          .setImageResource(plugin.getTextColor() == Color.BLACK ? R.drawable.arrow_right_bk : R.drawable.arrow_right_wh);
    });
  }

  @Override
  protected void bindTitle(PushItem pushItem) {
  }

  @Override
  protected void bindContent(PushItem pushItem) {
    if (textPopupMessage != null) {
      textPopupMessage.setText(pushItem.getFormattedSpanMessageWithTitle());
    }
  }

  @Override
  protected void bindButton() {
    if (item != null && item.getButtonTitle() != null) {
      buttonPushBotPopupButton.setVisibility(VISIBLE);
    } else {
      buttonPushBotPopupButton.setVisibility(GONE);
    }
  }
}
