package com.zoyi.channel.plugin.android.util.message_format.message;

import android.graphics.Typeface;
import android.support.v4.util.Pair;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;

import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RegexUtils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class BoldMessage implements MessagePattern {

  private Pattern boldPattern = Pattern.compile("(\\*\\*)(.+?)\\1");

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {

    for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(boldPattern.matcher(span))) {
      int start = range.first;
      int end = range.second;

      span.delete(end - 2, end);
      span.delete(start, start + 2);
      span.setSpan(new StyleSpan(Typeface.BOLD), start, end - 4, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
    }

    return span;
  }
}
