package com.zoyi.channel.plugin.android.activity.chats;

import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.activity.chats.contract.ChatsAdapterContract;
import com.zoyi.channel.plugin.android.activity.chats.contract.ChatsContract;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.selector2.ChatsSelector;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;
import com.zoyi.channel.plugin.android.util.ResUtils;

import java.util.ArrayList;
import java.util.List;

public class ChatsPresenter
    extends AbstractAdapterPresenter<ChatsContract.View, ChatsAdapterContract.View, ChatsAdapterContract.Model>
    implements ChatsContract.Presenter {

  public ChatsPresenter(
      ChatsContract.View view,
      ChatsAdapterContract.View adapterView,
      ChatsAdapterContract.Model adapterModel
  ) {
    super(view, adapterView, adapterModel);
  }

  @Override
  public void init() {
    bind(ChatsSelector.bindChats((activeChatItems, closedChatItems) -> {
      boolean isOnTop = view.isOnTop();

      List<ChatItem> chatItems = new ArrayList<>();

      chatItems.addAll(activeChatItems);
      chatItems.addAll(closedChatItems);

      adapterModel.updateChatItems(chatItems);
      view.onChatsCountChange(chatItems.size());

      if (isOnTop) {
        view.scrollToTop();
      }
    }));

    bind(ChatsSelector.bindUserChatsFetchState(fetchState -> {
      view.onUserChatsFetchStateChange(fetchState);
    }));
  }

  @Override
  public void removeChat(ChatItem item) {
    if (item instanceof PushBotChatItem) {
      PushBotItem pushBotItem = PushBotStore.get().pushBots.get(item.getId());

      if (pushBotItem != null) {
        pushBotItem.remove();

        PushBotStore.get().pushBots.upsert(pushBotItem);
      }
    }
    if (item instanceof UserChatItem) {
      view.showProgress(ResUtils.getString("ch.chat.delete_progress"));

      ChatAction.removeUserChat(
          item.getId(),
          () -> {
            view.hideProgress();
            UserChatStore.get().userChats.removeByKey(item.getId());
          },
          () -> view.hideProgress()
      );
    }
  }
}
