package com.zoyi.channel.plugin.android.activity.chat3.manager.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat3.listener.MessageSendListener;

import java.util.Collection;
import java.util.List;

public interface ChatManagerImpl {

  void attachListener(@Nullable MessageSendListener listener);

  void clearListener();

  void send(@Nullable SendingMessageItem item);

  void send(@Nullable Collection<SendingMessageItem> items);

  void resend(@Nullable SendingMessageItem item);

  @NonNull
  List<SendingMessageItem> getUnsentItems();

  void removeFailedItem(SendingMessageItem item);

  void release();
}
