/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.model.wrapper.BaseRepo;
import com.zoyi.channel.plugin.android.store2.BotStore;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;

public class PluginWrapper
extends BaseRepo {
    private Plugin plugin;
    private Channel channel;
    private User user;
    private Veil veil;
    private Bot bot;

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public User getUser() {
        return this.user;
    }

    public Veil getVeil() {
        return this.veil;
    }

    public Bot getBot() {
        return this.bot;
    }

    public Guest getGuest() {
        return this.user != null ? this.user : this.veil;
    }

    @Override
    public void set() {
        PluginStore.get().pluginState.set(this.plugin);
        ChannelStore.get().channelState.set(this.channel);
        GuestStore.get().guest.set(this.getGuest());
        BotStore.get().bots.upsert(this.bot);
        if (this.bot != null) {
            BotStore.get().defaultBotId.set(this.bot.getId());
        }
    }

    @Override
    public boolean isValid() {
        return this.plugin != null && this.channel != null && (this.user != null || this.veil != null);
    }

    public boolean canUseMobileSDK() {
        return this.channel != null && this.channel.canUseMobileSdk();
    }
}

