package com.zoyi.channel.plugin.android.selector2;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store2.*;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder1;
import com.zoyi.channel.plugin.android.store2.binder.Binder3;
import com.zoyi.channel.plugin.android.store2.binder.Binder8;
import com.zoyi.channel.plugin.android.store2.state.BooleanState;
import com.zoyi.channel.plugin.android.store2.state.EntityMapState;
import com.zoyi.channel.plugin.android.store2.state.MapState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;

import java.util.ArrayList;
import java.util.List;

public class ChatsSelector {

  public static Binder bindChats(Action2<List<ChatItem>, List<ChatItem>> action2) {
    EntityMapState<PushBotItem> pushBotItemsState = PushBotStore.get().pushBots;
    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    MapState<String, Session> sessionsState = UserChatStore.get().sessions;
    MapState<String, Message> messagesState = UserChatStore.get().messages;
    EntityMapState<Manager> managersState = ManagerStore.get().managers;
    EntityMapState<Bot> botsState = BotStore.get().bots;
    State<String> defaultBotIdState = Store2.getInstance(BotStore.class).defaultBotId;
    BooleanState showClosedChatsState = SettingsStore.get().showClosedChat;

    return new Binder8<>(
        pushBotItemsState,
        userChatsState,
        sessionsState,
        messagesState,
        managersState,
        botsState,
        defaultBotIdState,
        showClosedChatsState
    ).bind((pushBotItems, userChats, sessions, messages, managers, bots, defaultBotId, showClosedChat) -> {
      List<ChatItem> activeChatItems = new ArrayList<>();
      List<ChatItem> closedChatItems = new ArrayList<>();

      for (PushBotItem pushBotItem : pushBotItems.values()) {
        if (pushBotItem.isActive()) {
          activeChatItems.add(new PushBotChatItem(pushBotItem));
        }
      }

      for (UserChat userChat : userChats.values()) {
        if (userChat.isStateRemoved()) {
          continue;
        }

        Message message = messages.get(userChat.getId());
        Session session = sessions.get(userChat.getId());
        ProfileEntity profileEntity = null;

        if (Const.MANAGER.equals(userChat.getAssigneeType())) {
          profileEntity = managers.get(userChat.getAssigneeId());
        } else if (Const.BOT.equals(userChat.getAssigneeType())) {
          profileEntity = bots.get(userChat.getAssigneeId());
        }

        if (profileEntity == null && defaultBotId != null) {
          profileEntity = bots.get(defaultBotId);
        }

        ChatItem newChatItem = new UserChatItem(userChat, message, session, profileEntity);

        if (showClosedChat && userChat.isStateClosed()) {
          closedChatItems.add(newChatItem);
        } else if (!userChat.isStateClosed()) {
          activeChatItems.add(newChatItem);
        }
      }

      action2.call(activeChatItems, closedChatItems);
    });
  }

  public static Binder bindUserChatsFetchState(Action1<FetchState> action1) {
    return new Binder1<>(UserChatStore.get().userChatsFetchState).bind(action1);
  }

  public static Binder binderHost(@Nullable String chatId, Action2<ProfileEntity, Boolean> action2) {
    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    EntityMapState<Manager> managersState = ManagerStore.get().managers;
    State<Channel> channelState = Store2.getInstance(ChannelStore.class).channelState;

    return new Binder3<>(userChatsState, managersState, channelState).bind(
        (userChats, managers, channel) -> {
          UserChat userChat = chatId != null ? userChats.get(chatId) : null;

          if (userChat == null) {
            action2.call(channel, null);
            return;
          }

          Manager manager = Const.MANAGER.equals(userChat.getAssigneeType()) && userChat.getAssigneeId() != null
              ? managers.get(userChat.getAssigneeId())
              : null;

          if (manager != null) {
            action2.call(manager, manager.getOnline());
          } else {
            action2.call(channel, null);
          }
        });
  }
}
