package com.zoyi.channel.plugin.android.push_bot;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.PushBot;
import com.zoyi.channel.plugin.android.model.wrapper.EventRepo;
import com.zoyi.channel.plugin.android.model.wrapper.PushBotReachRepo;
import com.zoyi.channel.plugin.android.selector2.PushSelector;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.rx.Observable;
import com.zoyi.rx.functions.Func1;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by jerry on 2018. 11. 9..
 */

public class PushBotManager {

  public static Observable<PushBotReachRepo> handlePushBot(@Nullable EventRepo eventRepo) {
    // Check whether push bot has already been tried reach.
    // wait delay
    // try reach
    if (eventRepo != null && eventRepo.getPushBotCandidates() != null) {
      return Observable.from(eventRepo.getPushBotCandidates())
          .filter(PushSelector::canTryReach)
          .toList()
          .flatMap((Func1<List<PushBot>, Observable<PushBot>>) Observable::from)
          .flatMap(
              (Func1<PushBot, Observable<PushBot>>) pushBot -> Observable.just(pushBot).delay(pushBot.getTriggerDelay(), TimeUnit.SECONDS)
          )
          .concatMap((Func1<PushBot, Observable<PushBotReachRepo>>) pushBot -> ChannelApiManager.get().reachPushBot(pushBot.getId()))
          .filter(PushBotReachRepo::isReach)
          .firstOrDefault(null);
    } else {
      return Observable.empty();
    }
  }

  public static void doPushBotAction(@NonNull PushBotReachRepo pushBotReachRepo, @Nullable Activity topActivity) {
    if (pushBotReachRepo.isValid()) {
      PushBotItem pushBotItem = PushBotItem.newInstance(
          pushBotReachRepo.getPushBot(),
          pushBotReachRepo.getPushBotVariant(),
          topActivity
      );

      if (!pushBotReachRepo.isOriginState()) {
        pushBotReachRepo.set();

        for (PushBotItem item : PushBotStore.get().pushBots.get().values()) {
          item.hidePopup();
        }
      }

      PushBotStore.get().pushBots.upsert(pushBotItem);
    }
  }
}
