/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.photo_picker.OnPhotoClickListener;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoHolder;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class PhotoPickerAdapter
extends RecyclerView.Adapter<PhotoHolder>
implements PhotoPickerAdapterContract.View,
PhotoPickerAdapterContract.Model {
    private Context context;
    @Nullable
    private OnPhotoClickListener listener;
    private ArrayList<PhotoItem> photoItems;
    private ArrayList<String> selectedPaths;
    private Map<String, Integer> indexMap;
    private int itemSize;
    private int itemMargin;

    PhotoPickerAdapter(Context context) {
        this.context = context;
        this.photoItems = new ArrayList();
        this.selectedPaths = new ArrayList();
        this.indexMap = new HashMap<String, Integer>();
        this.itemSize = Display.getWidth(context) / 3;
        this.itemMargin = (int)Utils.dpToPx(context, 2.0f);
    }

    @Override
    public void setOnPhotoClickListener(OnPhotoClickListener listener) {
        this.listener = listener;
    }

    public PhotoHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PhotoHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.ch_plugin_item_photo_picker, parent, false), this.itemSize, this.itemMargin, this.listener);
    }

    public void onBindViewHolder(PhotoHolder holder, int position) {
        PhotoItem photoItem = this.photoItems.get(position);
        holder.setValue(photoItem, position, this.selectedPaths.contains(photoItem.getPath()));
    }

    public int getItemCount() {
        return this.photoItems.size();
    }

    @Override
    public void setPhotoItems(ArrayList<PhotoItem> photoItems) {
        this.photoItems = photoItems;
        for (int i = 0; i < photoItems.size(); ++i) {
            PhotoItem photoItem = photoItems.get(i);
            if (photoItem == null || photoItem.getPath() == null) continue;
            this.indexMap.put(photoItem.getPath(), i);
        }
        this.notifyDataSetChanged();
    }

    @Override
    public boolean onPhotoItemClick(PhotoItem photoItem) {
        String path = photoItem.getPath();
        if (path != null) {
            if (this.selectedPaths.contains(path)) {
                int oldSelectIndex = this.selectedPaths.indexOf(path);
                if (oldSelectIndex >= 0) {
                    this.selectedPaths.remove(oldSelectIndex);
                    this.updateItemIndex(path);
                    for (int i = oldSelectIndex; i < this.selectedPaths.size(); ++i) {
                        this.updateItemIndex(this.selectedPaths.get(i));
                    }
                }
            } else if (this.selectedPaths.size() < 20) {
                this.selectedPaths.add(path);
                this.updateItemIndex(path);
            } else {
                return false;
            }
        }
        return true;
    }

    private void updateItemIndex(@Nullable String path) {
        Integer index;
        if (path != null && this.indexMap.containsKey(path) && (index = this.indexMap.get(path)) != null && index >= 0) {
            this.notifyItemChanged(index);
        }
    }

    @Override
    public ArrayList<String> getSelectedPaths() {
        return this.selectedPaths;
    }
}

