package com.zoyi.channel.plugin.android.util;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.message_format.span.GiantEmojiSpan;

/**
 * Created by jerry on 2018. 10. 23..
 */

public class MessageUtils {

  public static boolean hasOnlyEmoji(SpannableStringBuilder formattedSpanMessage) {
    return formattedSpanMessage != null
        && formattedSpanMessage.length() > 0
        && formattedSpanMessage.getSpans(0, formattedSpanMessage.length(), GiantEmojiSpan.class).length > 0;
  }

  @NonNull
  public static String createWelcomeMessage(Plugin plugin, Guest guest, CHLocale locale) {
    String guestName = guest != null && guest.isNamed() ? guest.getName() : null;

    if (plugin != null && locale != null) {
      if (guestName != null) {
        String namedFormat = plugin.getWelcomeNamedI18n().get(locale.toString());

        if (namedFormat != null) {
          return namedFormat.replace("${name}", guestName);
        }
      }
      String anonymousFormat = plugin.getWelcomeI18n().get(locale.toString());

      if (anonymousFormat != null) {
        return anonymousFormat;
      }
    }
    return ResUtils.getString(ChannelIO.getAppContext(), "ch.scripts.welcome_veil.default");
  }
}
