/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.app.Application;
import android.content.Context;
import android.location.Location;
import com.github.anrwatchdog.ANRError;
import com.github.anrwatchdog.ANRWatchDog;
import com.splunk.mint.ActionError;
import com.splunk.mint.ActionEvent;
import com.splunk.mint.ActionTransactionStart;
import com.splunk.mint.ActionTransactionStop;
import com.splunk.mint.ActionView;
import com.splunk.mint.ActivityLifecycleCallbacksManager;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.CrashInfo;
import com.splunk.mint.DataSaver;
import com.splunk.mint.ExceptionHandler;
import com.splunk.mint.ExtraData;
import com.splunk.mint.ForegroundHandler;
import com.splunk.mint.InstrumentationEnvironment;
import com.splunk.mint.InstrumentationEnvironmentUtils;
import com.splunk.mint.LastPing;
import com.splunk.mint.Logger;
import com.splunk.mint.MemoryTrimHandler;
import com.splunk.mint.MintCallback;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.Properties;
import com.splunk.mint.SequentialExecutor;
import com.splunk.mint.TimerManager;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.http.MonitorableURLStreamHandlerFactory;
import com.splunk.mint.network.socket.MonitoringSocketFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import org.json.JSONObject;

public final class Mint {
    static boolean DEBUG = false;
    static boolean netInitializedSuccessfully = false;
    static boolean triedToInitNet = false;
    private static MonitorRegistry registry = new MonitorRegistry();
    private static boolean isSessionActive = false;
    private static boolean networkMonitoringEnabled = true;
    private static boolean crashMonitoringEnabled = true;
    static MintCallback mintCallback = null;
    public static final String appEnvironmentRelease = "Release";
    public static final String appEnvironmentStaging = "Staging";
    public static final String appEnvironmentUserAcceptanceTesting = "UserAcceptanceTesting";
    public static final String appEnvironmentTesting = "Testing";
    public static final String appEnvironmentDevelopment = "Development";
    private static boolean memoryPressureMonitoringEnabled = true;
    public static final String XSplunkMintSessionIdHeader = "X-Splunk-Mint-Session-id";
    public static final String XSplunkMintUuidHeader = "X-Splunk-Mint-uuid";
    private static final SequentialExecutor executor = new SequentialExecutor();

    public static void initAndStartSession(Application app, String apiKey) {
        Properties.hecEnabled = false;
        Mint.initAndStartSession(app, apiKey, null, null);
    }

    public static void initAndStartSessionHEC(Application app, String url, String token) {
        Properties.hecEnabled = true;
        Mint.initAndStartSession(app, "NA", url, token);
    }

    private static synchronized void initAndStartSession(final Application app, final String apiKey, final String url, final String token) {
        if (app == null) {
            Logger.logWarning("Application is null!");
            return;
        }
        if (Properties.hecEnabled) {
            Mint.doUrlChecksForHEC(url, token);
            Properties.hecToken = token;
        } else {
            Mint.doUrlChecksForCDS(apiKey);
        }
        Properties.TIMESTAMP = System.currentTimeMillis();
        Mint.logFeatureStates();
        ForegroundHandler.initialize(app);
        Mint.installExceptionHandler();
        Mint.installMemoryPressureHandler(app);
        Mint.installActivityLifecycleHandler(app);
        if (!netInitializedSuccessfully) {
            Mint.initializeNetworkMonitoring();
        }
        final ActionEvent ping = ActionEvent.createPing();
        executor.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Properties.initialize((Context)app, url, token, apiKey);
                Mint.startSession(ping, app);
                Mint.flush();
            }
        });
    }

    private static void logFeatureStates() {
        Mint.logFeatureState("Crash Monitoring", crashMonitoringEnabled);
        Mint.logFeatureState("Network Monitoring", networkMonitoringEnabled);
    }

    private static void doUrlChecksForHEC(String url, String token) {
        if (url == null) {
            throw new IllegalArgumentException("Your Mint HEC URL is null!");
        }
        if (token == null) {
            throw new IllegalArgumentException("Your Mint HEC Token is null!");
        }
        if (url.length() < 10) {
            throw new IllegalArgumentException("Your Mint HEC URL is invalid!");
        }
        if (token.length() < 10) {
            throw new IllegalArgumentException("Your Mint HEC Token is invalid!");
        }
        if (!url.toLowerCase().startsWith("http")) {
            throw new IllegalArgumentException("Your Mint HEC URL is invalid!");
        }
    }

    private static void doUrlChecksForCDS(String apiKey) {
        if (apiKey == null || apiKey.length() < 8 || apiKey.length() > 14) {
            throw new IllegalArgumentException("Your Mint API Key is invalid!");
        }
        Properties.API_KEY = apiKey;
    }

    private static synchronized void initializeNetworkMonitoring() {
        if (networkMonitoringEnabled) {
            if (!Mint.networkMonitoredByBuildtimeInstrumentation()) {
                if (!triedToInitNet && NetLogManager.deviceSupporsNetworkMonitoring() && Properties.RemoteSettingsProps.netMonitoringEnabled.booleanValue()) {
                    Logger.logInfo("Initializing Network Monitoring");
                    triedToInitNet = true;
                    try {
                        URL.setURLStreamHandlerFactory(new MonitorableURLStreamHandlerFactory(Mint.getRegistry()));
                    }
                    catch (Throwable e) {
                        netInitializedSuccessfully = false;
                    }
                    try {
                        MonitoringSocketFactory factory = new MonitoringSocketFactory(registry);
                        Socket.setSocketImplFactory(factory);
                        SSLSocket.setSocketImplFactory(factory);
                        netInitializedSuccessfully = true;
                    }
                    catch (Throwable e) {
                        netInitializedSuccessfully = false;
                    }
                    if (netInitializedSuccessfully) {
                        Logger.logInfo("Network monitoring was initialized successfully!");
                    }
                }
            } else {
                netInitializedSuccessfully = true;
            }
        }
    }

    static void disableInstrumentationNetworkMonitoring() {
        InstrumentationEnvironment env = InstrumentationEnvironmentUtils.getInstance();
        if (env == null) {
            return;
        }
        env.disableNetworkMonitoring();
    }

    static boolean networkMonitoredByBuildtimeInstrumentation() {
        InstrumentationEnvironment env = InstrumentationEnvironmentUtils.getInstance();
        if (env == null) {
            return false;
        }
        boolean isAppliedAtBuildTime = env.isAppliedAtBuildtime();
        if (isAppliedAtBuildTime) {
            Logger.logInfo("Network monitoring is applied at build time");
        }
        return isAppliedAtBuildTime;
    }

    private static MonitorRegistry getRegistry() {
        if (registry == null) {
            registry = new MonitorRegistry();
        }
        return registry;
    }

    public static synchronized void startSession(Application app) {
        if (Properties.isPluginInitialized()) {
            ActionEvent ping = ActionEvent.createPing();
            Mint.startSession(ping, app);
        }
    }

    private static synchronized void startSession(final ActionEvent ping, final Application app) {
        if (app == null) {
            Logger.logWarning("Application is null!");
            return;
        }
        if (!isSessionActive) {
            isSessionActive = true;
            Properties.initialize((Context)app, null, null, null);
        }
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                if (LastPing.shouldSendPing((Context)app)) {
                    ping.resetSessionID();
                    ping.send((Context)app, true);
                }
            }
        });
    }

    public static synchronized void closeSession(Application app) {
        if (Properties.isPluginInitialized() && isSessionActive) {
            isSessionActive = false;
            ActionEvent event = ActionEvent.createGnip((Context)app);
            event.save();
            LastPing.clearLastPingSentTime((Context)app);
        }
    }

    public static void flush() {
        if (Properties.isPluginInitialized()) {
            DataSaver.flush();
        }
    }

    public static final void startANRMonitoring(int timeout, boolean ignoreDebugger) {
        if (timeout > 5000) {
            Logger.logWarning("Timeout should be less or equal to 5000");
        }
        Mint.logFeatureState("ANR Monitoring", true);
        new ANRWatchDog(timeout).setANRListener(new ANRWatchDog.ANRListener(){

            @Override
            public void onAppNotResponding(ANRError error) {
                if (Properties.isPluginInitialized()) {
                    Mint.logException("ANR", "true", new Exception(error));
                }
            }
        }).setIgnoreDebugger(ignoreDebugger).start();
    }

    private static void logFeatureState(String feature, boolean state) {
        Logger.logInfo(feature + " enabled = " + state);
    }

    public static void setSessionInterval(int timeInSecs) {
        if (timeInSecs < 30 || timeInSecs > 86400) {
            Properties.RemoteSettingsProps.sessionTime = 60;
            Logger.logError("time for session interval should be more than 30 seconds and less than a day, setting default to 60 seconds");
        } else {
            Properties.RemoteSettingsProps.sessionTime = timeInSecs;
        }
    }

    public static void setUserOptOut(boolean optedOut) {
        Properties.USER_OPTEDOUT = optedOut;
    }

    public static void disableNetworkMonitoring() {
        networkMonitoringEnabled = false;
        Mint.disableInstrumentationNetworkMonitoring();
    }

    public static void disableCrashMonitoring() {
        crashMonitoringEnabled = false;
    }

    public static final void setMintCallback(MintCallback mintCallback) {
        Mint.mintCallback = mintCallback;
    }

    public static void leaveBreadcrumb(String breadcrumb) {
        if (Properties.isPluginInitialized() && breadcrumb != null) {
            Properties.breadcrumbs.addToList(breadcrumb);
        }
    }

    public static void logView(String view) {
        if (Properties.isPluginInitialized() && view != null) {
            ActionView.logView(view, null);
        }
    }

    public static void logView(String view, String key, String value) {
        if (Properties.isPluginInitialized() && view != null) {
            HashMap<String, Object> extraData = new HashMap<String, Object>(1);
            extraData.put(key, value);
            ActionView.logView(view, extraData);
        }
    }

    public static void logView(String view, HashMap<String, Object> extraData) {
        if (Properties.isPluginInitialized() && view != null) {
            ActionView.logView(view, extraData);
        }
    }

    public static void logEvent(String eventName) {
        if (Properties.isPluginInitialized() && eventName != null) {
            ActionEvent event = ActionEvent.createEvent(eventName);
            event.save();
        }
    }

    public static void logEvent(String eventName, MintLogLevel logLevel) {
        if (Properties.isPluginInitialized() && eventName != null) {
            ActionEvent event = ActionEvent.createEvent(eventName, logLevel, null);
            event.save();
        }
    }

    public static void logEvent(String eventName, MintLogLevel logLevel, HashMap<String, Object> customData) {
        if (Properties.isPluginInitialized() && eventName != null) {
            ActionEvent event = ActionEvent.createEvent(eventName, logLevel, customData);
            event.save();
        }
    }

    public static void logEvent(String eventName, MintLogLevel logLevel, String keyName, String keyValue) {
        if (Properties.isPluginInitialized()) {
            HashMap<String, Object> customData = new HashMap<String, Object>(1);
            customData.put(keyName, keyValue);
            Mint.logEvent(eventName, logLevel, customData);
        }
    }

    public static void setUserIdentifier(String userIdentifier) {
        Properties.userIdentifier = userIdentifier;
    }

    public static void setApplicationEnvironment(String environment) {
        if (environment != null && environment.length() > 0) {
            Properties.applicationEnvironment = environment;
        }
    }

    public static void enableDebugLog() {
        DEBUG = true;
    }

    public static void setFlushOnlyOverWiFi(boolean enabled) {
        Properties.flushOnlyOverWiFi = enabled;
    }

    public static String transactionStart(String name) {
        String txID = null;
        if (Properties.isPluginInitialized() && name != null && name.length() > 0) {
            ActionTransactionStart mTransactionStart = ActionTransactionStart.createTransactionStart(name, null);
            mTransactionStart.save();
            txID = mTransactionStart.transaction_id;
        }
        return txID;
    }

    public static String transactionStart(String name, HashMap<String, Object> customData) {
        String txID = null;
        if (Properties.isPluginInitialized() && name != null && name.length() > 0) {
            ActionTransactionStart mTransactionStart = ActionTransactionStart.createTransactionStart(name, customData);
            mTransactionStart.save();
            txID = mTransactionStart.transaction_id;
        }
        return txID;
    }

    public static String transactionStart(String name, String keyName, String keyValue) {
        String txID = null;
        if (Properties.isPluginInitialized()) {
            HashMap<String, Object> customData = new HashMap<String, Object>(1);
            customData.put(keyName, keyValue);
            txID = Mint.transactionStart(name, customData);
        }
        return txID;
    }

    public static void transactionStop(String id) {
        if (Properties.isPluginInitialized() && id != null && id.length() > 0) {
            ActionTransactionStop mTransactionStop = ActionTransactionStop.createTransactionStop(id, null);
            if (mTransactionStop == null) {
                return;
            }
            mTransactionStop.save();
        }
    }

    public static void transactionStop(String id, HashMap<String, Object> customData) {
        if (Properties.isPluginInitialized() && id != null && id.length() > 0) {
            ActionTransactionStop mTransactionStop = ActionTransactionStop.createTransactionStop(id, customData);
            if (mTransactionStop == null) {
                return;
            }
            mTransactionStop.save();
        }
    }

    public static void transactionStop(String id, String keyName, String keyValue) {
        if (Properties.isPluginInitialized() && id != null && id.length() > 0) {
            HashMap<String, Object> customData = new HashMap<String, Object>(1);
            customData.put(keyName, keyValue);
            Mint.transactionStop(id, customData);
        }
    }

    public static void transactionCancel(String id, String reason) {
        if (Properties.isPluginInitialized() && id != null && id.length() > 0) {
            ActionTransactionStop mTransactionStop = ActionTransactionStop.createTransactionCancel(id, reason, null);
            if (mTransactionStop == null) {
                return;
            }
            mTransactionStop.save();
        }
    }

    public static void transactionCancel(String id, String reason, HashMap<String, Object> customData) {
        if (Properties.isPluginInitialized() && id != null && id.length() > 0) {
            ActionTransactionStop mTransactionStop = ActionTransactionStop.createTransactionCancel(id, reason, customData);
            if (mTransactionStop == null) {
                return;
            }
            mTransactionStop.save();
        }
    }

    public static void transactionCancel(String id, String reason, String keyName, String keyValue) {
        if (Properties.isPluginInitialized() && id != null && id.length() > 0) {
            HashMap<String, Object> customData = new HashMap<String, Object>(1);
            customData.put(keyName, keyValue);
            Mint.transactionCancel(id, reason, customData);
        }
    }

    public static String timerStart(String name) {
        String timerID = null;
        if (Properties.isPluginInitialized()) {
            timerID = TimerManager.getInstance().timerStart(name);
        }
        return timerID;
    }

    public static void timerStop(String id) {
        if (Properties.isPluginInitialized() && id != null && id.length() > 0) {
            TimerManager.getInstance().timerStop(id);
        }
    }

    public static HashMap<String, Object> getExtraData() {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> curObj : Properties.extraData.getExtraData().entrySet()) {
            newMap.put(curObj.getKey(), curObj.getValue());
        }
        return newMap;
    }

    public static void addExtraData(String key, String value) {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        if (key != null) {
            if (value == null) {
                value = "null";
            }
            Properties.extraData.addExtraData(key, value);
        }
    }

    public static void removeExtraData(String key) {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        if (key != null) {
            Properties.extraData.removeKey(key);
        }
    }

    public static void clearExtraData() {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        Properties.extraData.clearData();
    }

    public static int getTotalCrashesNum() {
        return new CrashInfo().getTotalCrashesNum();
    }

    public static void clearTotalCrashesNum() {
        if (Properties.isPluginInitialized()) {
            new CrashInfo().clearCrashCounter();
        }
    }

    public static String getLastCrashID() {
        return new CrashInfo().getLastCrashID();
    }

    public static void logException(HashMap<String, Object> customData, Exception exception) {
        if (Properties.isPluginInitialized()) {
            StringWriter stacktrace = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stacktrace);
            exception.printStackTrace(printWriter);
            ActionError mCrashData = new ActionError(0, ((Object)stacktrace).toString(), 0, customData);
            mCrashData.save();
        }
    }

    public static void logException(Exception ex) {
        HashMap<String, Object> extraData = new HashMap<String, Object>(0);
        Mint.logException(extraData, ex);
    }

    public static void logException(String key, String value, Exception exception) {
        HashMap<String, Object> extraData = new HashMap<String, Object>(1);
        if (key != null && value != null) {
            extraData.put(key, value);
        }
        Mint.logException(extraData, exception);
    }

    public static void xamarinException(Exception exception, boolean handled, HashMap<String, Object> customData) {
        StringWriter stacktrace = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stacktrace);
        exception.printStackTrace(printWriter);
        byte isHandled = 1;
        if (handled) {
            isHandled = 0;
        }
        ActionError mCrashData = new ActionError(0, ((Object)stacktrace).toString().replaceFirst("\n", "\n\t"), isHandled, customData);
        mCrashData.save();
    }

    public static void enableLogging(boolean enable) {
        Properties.SEND_LOG = enable;
    }

    public static void setLogging(int lines) {
        if (lines > 0) {
            Properties.SEND_LOG = true;
            Properties.LOG_LINES = lines;
        }
    }

    public static void setLogging(String filter) {
        if (filter != null) {
            Properties.SEND_LOG = true;
            Properties.LOG_FILTER = filter;
        }
    }

    public static void setLogging(int lines, String filter) {
        if (filter != null && lines > 0) {
            Properties.SEND_LOG = true;
            Properties.LOG_LINES = lines;
            Properties.LOG_FILTER = filter;
        }
    }

    public static JSONObject getDevSettings() {
        return Properties.RemoteSettingsProps.devSettings;
    }

    public static void addURLToBlackList(String url) {
        if (url != null) {
            Properties.excludedUrls.addValue(url);
        }
    }

    private static void installExceptionHandler() {
        if (!crashMonitoringEnabled) {
            return;
        }
        Logger.logInfo("Registering the exception handler");
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(currentHandler instanceof ExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(currentHandler));
        }
    }

    public static void disableMemoryPressureMonitoring() {
        memoryPressureMonitoringEnabled = false;
    }

    private static void installMemoryPressureHandler(Application app) {
        if (memoryPressureMonitoringEnabled) {
            MemoryTrimHandler.initialize(app);
        }
    }

    private static void installActivityLifecycleHandler(Application app) {
        ActivityLifecycleCallbacksManager.initialize(app);
    }

    public static final String getSessionId() {
        String sessionId = BaseDTO.getGlobalSessionID();
        if (sessionId != null && sessionId.length() > 0) {
            return sessionId;
        }
        return "NA";
    }

    public static final String getMintUUID() {
        if (Properties.UID != null || Properties.UID.length() > 0) {
            return Properties.UID;
        }
        return "NA";
    }

    public static void setLocation(Location location) {
        Properties.location = location;
    }
}

