/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.global;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.wrapper.ChannelWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.EventRepo;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ManagersWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessengersRepo;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ProfileBotSchemasRepo;
import com.zoyi.channel.plugin.android.model.wrapper.PushBotReachRepo;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.util.BootManager;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Observable;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.List;

public class Api<E> {
    @Nullable
    private static ChannelApi channelApi;
    private Observable<E> observable;
    @Nullable
    private ActionType actionType;
    @Nullable
    private ActionType[] cancelTypes;

    private static ChannelApi get() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    public static boolean isRunning(ActionType actionType) {
        return Action.isRunning(actionType);
    }

    private Api(Observable<E> observable) {
        this.observable = observable.onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Api<E> runBy(ActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public Api<E> cancelBy(ActionType ... actionTypes) {
        this.cancelTypes = actionTypes;
        return this;
    }

    public void run(RestSubscriber<E> subscriber) {
        Action.apiSubscribe(this.observable, subscriber, this.actionType, this.cancelTypes);
    }

    public static Api<PluginWrapper> boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, @Nullable OnBootListener listener) {
        return new Api<PluginWrapper>(Api.get().getLastestPackage("com.zoyi.channel.plugin.android", "6.1.4").filter(packageInfo -> BootManager.isValidVersion(packageInfo, listener)).flatMap(__ -> BootManager.bootPlugin(pluginSettings, profile)).filter(pluginInfo -> BootManager.isValidPlugin(pluginInfo, listener)));
    }

    public static Api<PushBotReachRepo> trackEvent(String pluginId, RequestBody body, Func1<EventRepo, Observable<PushBotReachRepo>> observableGetter) {
        return new Api<PushBotReachRepo>(Api.get().trackEvent(pluginId, body).flatMap(observableGetter));
    }

    public static Api<UserChatsWrapper> getUserChats(String sortField, String sortOrder, Integer limit, boolean includeClosed) {
        return new Api<UserChatsWrapper>(Api.get().getUserChats(sortField, sortOrder, limit, includeClosed));
    }

    public static Api<ManagersWrapper> getOperators() {
        return new Api<ManagersWrapper>(Api.get().getOperators());
    }

    public static Api<ChannelWrapper> getChannel() {
        return new Api<ChannelWrapper>(Api.get().getChannel());
    }

    public static Api<PluginWrapper> getPlugin(String pluginId) {
        return new Api<PluginWrapper>(Api.get().getPlugin(pluginId));
    }

    public static Api<SupportBotEntry> getSupportBot(String pluginId) {
        return new Api<SupportBotEntry>(Api.get().getSupportBot(pluginId));
    }

    public static Api<GuestWrapper> touch() {
        return new Api<GuestWrapper>(Api.get().touch());
    }

    public static Api<GuestWrapper> touch(String locale) {
        return new Api<GuestWrapper>(Api.get().touch(locale));
    }

    public static Api<UserChatWrapper> getUserChat(String userChatId) {
        return new Api<UserChatWrapper>(Api.get().getUserChat(userChatId));
    }

    public static Api<Void> removeUserChat(String userChatId) {
        return new Api<Void>(Api.get().removeUserChat(userChatId));
    }

    public static Api<Void> requestProfileBot(String chatId, String pluginId) {
        return new Api<Void>(Api.get().requestProfileBot(chatId, pluginId));
    }

    public static Api<MessagesWrapper> getMessages(String userChatId, String since, Integer limit, String sortOrder) {
        return new Api<MessagesWrapper>(Api.get().getMessages(userChatId, since, limit, sortOrder));
    }

    public static Api<UserChatWrapper> createUserChat(String pluginId) {
        return new Api<UserChatWrapper>(Api.get().createUserChat(pluginId));
    }

    public static Api<UserChatWrapper> createPushBotUserChat(String pushBotId) {
        return new Api<UserChatWrapper>(Api.get().createPushBotUserChat(pushBotId));
    }

    public static Api<MessageWrapper> keepPushBot(String chatId) {
        return new Api<MessageWrapper>(Api.get().keepPushBot(chatId));
    }

    public static Api<UserChatWrapper> createSupportBotUserChat(String supportBotId) {
        return new Api<UserChatWrapper>(Api.get().createSupportBotUserChat(supportBotId));
    }

    public static Api<MessageWrapper> sendMessage(String userChatId, RequestBody body) {
        return new Api<MessageWrapper>(Api.get().sendMessage(userChatId, body));
    }

    public static Api<MessageWrapper> uploadFile(String userChatId, MultipartBody.Part file, RequestBody requestId) {
        return new Api<MessageWrapper>(Api.get().uploadFile(userChatId, file, requestId));
    }

    public static Api<MessageWrapper> closeUserChat(String userChatId, @Nullable String formId, String requestId) {
        return new Api<MessageWrapper>(Api.get().closeUserChat(userChatId, formId, requestId));
    }

    public static Api<MessageWrapper> reviewUserChat(String userChatId, @Nullable String formId, String review, String requestId) {
        return new Api<MessageWrapper>(Api.get().reviewUserChat(userChatId, formId, review, requestId));
    }

    public static Api<MessageWrapper> submitButtonAction(String userChatId, @Nullable String buttonId, @Nullable String messageId, @Nullable String requestId) {
        return new Api<MessageWrapper>(Api.get().submitButtonAction(userChatId, buttonId, messageId, requestId));
    }

    public static Api<Void> read(String chatId) {
        return new Api<Void>(Api.get().read(chatId));
    }

    public static Api<TranslationRepo> getTranslatedMessage(String messageId, String language) {
        return new Api<TranslationRepo>(Api.get().getTranslatedMessage(messageId, language));
    }

    public static Api<List<Country>> getCountries() {
        return new Api<List<Country>>(Api.get().getCountries());
    }

    public static Api<MessageWrapper> updateProfileBot(String messageId, RequestBody requestBody) {
        return new Api<MessageWrapper>(Api.get().updateProfileBot(messageId, requestBody));
    }

    public static Api<ProfileBotSchemasRepo> getProfileBotSchemas(String pluginId) {
        return new Api<ProfileBotSchemasRepo>(Api.get().getProfileBotSchemas(pluginId));
    }

    public static Api<GuestWrapper> updateGuest(RequestBody body) {
        return new Api<GuestWrapper>(Api.get().updateGuest(body));
    }

    public static Api<MessengersRepo> getMessengers() {
        return new Api<MessengersRepo>(Api.get().getMessengers());
    }
}

