package com.zoyi.channel.plugin.android.util.message_format.message;

import android.content.Context;
import android.support.v4.util.Pair;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.RegexUtils;

import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class EmojiMessage implements MessagePattern {

  private Pattern emojiPattern = Pattern.compile("(:)([a-zA-Z0-9_+-]+?)\\1");
  private Context context;

  public EmojiMessage(Context context) {
    this.context = context;
  }

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {

    for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(emojiPattern.matcher(span))) {
      int start = range.first;
      int end = range.second;

      String emojiKey = span.toString().substring(start + 1, end - 1);

      if (AssetUtils.getEmoji(context, emojiKey) != null) {
        span.delete(start, end);
        span.insert(start, AssetUtils.getEmoji(context, emojiKey));
      }
    }

    return span;
  }
}
