package com.zoyi.channel.plugin.android.store2.state;

// This is irregular state for only messages

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.subjects.PublishSubject;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MessagesState {

  private Map<String, Message> map = new HashMap<>();

  @Nullable
  private String chatId;

  private boolean initialized;

  private PublishSubject<Collection<Message>> setterSubject = PublishSubject.create();

  private PublishSubject<Collection<Message>> upsertSubject = PublishSubject.create();

  public Subscription attachSetterEvent(Action1<Collection<Message>> action) {
    return setterSubject
        .onBackpressureBuffer()
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(action);
  }

  public Subscription attachUpsertEvent(Action1<Collection<Message>> action) {
    return upsertSubject
        .onBackpressureBuffer()
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(action);
  }

  public void attachChatId(@Nullable String chatId) {
    if (chatId != null) {
      this.chatId = chatId;
      this.map.clear();
    }
  }

  public void set(Collection<Message> messages) {
    if (messages != null) {
      this.initialized = true;

      addOperation(messages);

      if (setterSubject != null) {
        setterSubject.onNext(this.map.values());
      }
    }
  }

  public void add(Message message) {
    if (message != null) {
      Observable.just(message)
          .onBackpressureBuffer()
          .observeOn(AndroidSchedulers.mainThread())
          .subscribe(m -> add(Collections.singleton(m)));
    }
  }

  public void add(Collection<Message> messages) {
    if (messages != null) {
      Collection<Message> newMessages = addOperation(messages);

      if (initialized && upsertSubject != null && newMessages.size() > 0) {
        upsertSubject.onNext(newMessages);
      }
    }
  }

  @NonNull
  private Collection<Message> addOperation(Collection<Message> messages) {
    Map<String, Message> addMap = new HashMap<>();

    if (this.map != null && this.chatId != null) {
      for (Message message : messages) {
        if (message == null || !this.chatId.equals(message.getChatId())) {
          continue;
        }

        String key = message.getId();
        Message oldbie = this.map.get(key);

        if (oldbie == null || CompareUtils.compare(oldbie.getCreatedAt(), message.getCreatedAt()) <= 0) {
          addMap.put(key, message);
        }
      }

      this.map.putAll(addMap);
    }
    return addMap.values();
  }

  public Map<String, Message> get() {
    return map;
  }

  public void clear() {
    this.chatId = null;
    this.initialized = false;
    this.map.clear();
  }

  public void reset() {
    this.chatId = null;
    this.initialized = false;
    this.map.clear();
  }
}
