package com.zoyi.channel.plugin.android.activity.chat3;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.view.DisplayCutout;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;

public class KeyboardUtils {

  private ChatActivity chatActivity;
  private View decorView;
  private View contentView;
  private RecyclerView recyclerView;

  public KeyboardUtils(ChatActivity activity, View contentView, RecyclerView recyclerView) {
    this.chatActivity = activity;
    this.decorView = activity.getWindow().getDecorView();
    this.contentView = contentView;
    this.recyclerView = recyclerView;

    //only required on newer android versions. it was working on API level 19 (Build.VERSION_CODES.KITKAT)
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
      decorView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }
  }

  public void enable() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
      decorView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }
  }

  public void disable() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
      decorView.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener);
    }
  }

  private Rect getDisplayCutout() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P &&
        decorView != null &&
        decorView.getRootWindowInsets() != null &&
        decorView.getRootWindowInsets().getDisplayCutout() != null
    ) {
      DisplayCutout displayCutout = decorView.getRootWindowInsets().getDisplayCutout();
      return new Rect(
          displayCutout.getSafeInsetLeft(),
          displayCutout.getSafeInsetTop(),
          displayCutout.getSafeInsetRight(),
          displayCutout.getSafeInsetBottom()
      );
    }
    return new Rect(0, 0, 0, 0);
  }

  private Rect getSystemWindowInsets() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M &&
        decorView != null &&
        decorView.getRootWindowInsets() != null
    ) {
      WindowInsets rootWindowInsets = decorView.getRootWindowInsets();
      return new Rect(
          rootWindowInsets.getSystemWindowInsetLeft(),
          rootWindowInsets.getSystemWindowInsetTop(),
          rootWindowInsets.getSystemWindowInsetRight(),
          rootWindowInsets.getSystemWindowInsetBottom()
      );
    }
    return new Rect(0, 0, 0, 0);
  }

  private Rect getStableInsets() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M &&
        decorView != null &&
        decorView.getRootWindowInsets() != null
    ) {
      WindowInsets rootWindowInsets = decorView.getRootWindowInsets();
      return new Rect(
          rootWindowInsets.getStableInsetLeft(),
          rootWindowInsets.getStableInsetTop(),
          rootWindowInsets.getStableInsetRight(),
          rootWindowInsets.getStableInsetBottom()
      );
    }
    return new Rect(0, 0, 0, 0);
  }

  //a small helper to allow showing the editText focus
  private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener() {
    @Override
    public void onGlobalLayout() {
      Rect r = new Rect();
      //r will be populated with the coordinates of your view that area still visible.
      decorView.getWindowVisibleDisplayFrame(r);

      Rect cutout = getDisplayCutout();
      Rect systemInsets = getSystemWindowInsets();
      Rect stableInsets = getStableInsets();

      //get screen height and calculate the difference with the useable area from the r
      int viewHeight = decorView.getContext().getResources().getDisplayMetrics().heightPixels;
      int windowHeight = r.bottom - r.top;
      int diff = viewHeight - stableInsets.top + cutout.top - windowHeight;

//      L.e("WindowVisible " + r.top + " " + r.right + " " + r.bottom + " " + r.left);
//      L.e("Cutout        " + cutout.top + " " + cutout.right + " " + cutout.bottom + " " + cutout.left);
//      L.e("System        " + systemInsets.top + " " + systemInsets.right + " " + systemInsets.bottom + " " + systemInsets.left);
//      L.e("Stable        " + stableInsets.top + " " + stableInsets.right + " " + stableInsets.bottom + " " + stableInsets.left);
//      L.e("# " + viewHeight + " " + windowHeight + " " + diff);
//      L.e("#");

      //if it could be a keyboard add the padding to the view
      if (diff != 0) {
        // if the use-able screen height differs from the total screen height we assume that it shows a keyboard now
        //check if the padding is 0 (if yes set the padding for the keyboard)
        if (contentView.getPaddingBottom() != diff) {
          boolean isOnBottom = !recyclerView.canScrollVertically(1);
          //set the padding of the contentView for the keyboard
          contentView.setPadding(0, 0, 0, diff);

          if (isOnBottom) {
            chatActivity.scrollToBottom();
          }
        }
      } else {
        //check if the padding is != 0 (if yes reset the padding)
        if (contentView.getPaddingBottom() != 0) {
          //reset the padding of the contentView
          contentView.setPadding(0, 0, 0, 0);
        }
      }
    }
  };


  /**
   * Helper to hide the keyboard
   *
   * @param activity
   */
  public static void hideKeyboard(Activity activity) {
    if (activity != null && activity.getCurrentFocus() != null) {
      InputMethodManager inputMethodManager = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
      inputMethodManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
    }
  }
}
