package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;

/**
 * Created by mika on 2016. 3. 14..
 */
public class RetrofitInterceptor implements Interceptor {
  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();

    Request.Builder builder = request.newBuilder();

    if (request.header(Const.ACCEPT_LANGUAGE) == null) {
      builder = builder.header(Const.ACCEPT_LANGUAGE, SettingsStore.get().locale.get().toString());
    }

    String jwt = GlobalStore.get().jwt.get();

    if (jwt != null) {
      builder.header(Const.X_GUEST_JWT, jwt);
    }

    return chain.proceed(builder.build());
  }
}
