/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.Views;

public class FetchLayout
extends FrameLayout {
    private View loader;
    private ErrorRefreshView errorView;
    private ViewGroup container;

    public FetchLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public FetchLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FetchLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_fetch, (ViewGroup)this, true);
        this.loader = view.findViewById(R.id.viewFetchLayoutLoader);
        this.container = (ViewGroup)view.findViewById(R.id.layoutFetchLayoutContainer);
        this.errorView = (ErrorRefreshView)view.findViewById(R.id.layoutFetchLayoutError);
        this.errorView.setListener(v -> this.onRefreshClick());
        this.loader.setVisibility(8);
        this.errorView.setVisibility(8);
    }

    public final void setFetchState(FetchState fetchState) {
        Views.setVisibility(this.loader, fetchState == FetchState.LOADING);
        Views.setVisibility((View)this.container, fetchState == FetchState.COMPLETE);
        Views.setVisibility((View)this.errorView, fetchState == FetchState.FAILED);
    }

    protected void onRefreshClick() {
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child == null) {
            return;
        }
        if (child.getId() == R.id.rootFetchLayout || child.getId() == R.id.viewFetchLayoutLoader || child.getId() == R.id.layoutFetchLayoutError || child.getId() == R.id.layoutFetchLayoutContainer) {
            super.addView(child, index, params);
        } else if (this.container != null) {
            this.container.addView(child, index, params);
        }
    }
}

