/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.BaseMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector2.StyleSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.message_format.CustomMovementMethod;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public abstract class TextMessageHolder
extends BaseMessageHolder {
    @Nullable
    private LinearLayout rootGuestMessageText;
    @Nullable
    private MaskableFrameLayout frameGuestMessageEdgeHead;
    @Nullable
    private MaskableFrameLayout frameGuestMessageCircleHead;
    @Nullable
    private TextView textGuestMessage;
    @Nullable
    private View viewGuestMessageEdgeHeadBackground;
    @Nullable
    private View viewGuestMessageCircleHeadBackground;
    @Nullable
    private LinearLayout rootHostMessageText;
    @Nullable
    private View frameHostMessageEdgeHead;
    @Nullable
    private View frameHostMessageCircleHead;
    @Nullable
    private TextView textHostMessage;
    private TextView textContentMessageGiantEmoji;

    protected TextMessageHolder(View itemView, MessageType messageType) {
        super(itemView, messageType);
        switch (messageType) {
            case GUEST: 
            case SENDING: {
                this.rootGuestMessageText = (LinearLayout)itemView.findViewById(R.id.ch_root_guest_message_text);
                this.frameGuestMessageEdgeHead = (MaskableFrameLayout)itemView.findViewById(R.id.ch_frame_guest_message_edge_head);
                this.frameGuestMessageCircleHead = (MaskableFrameLayout)itemView.findViewById(R.id.ch_frame_guest_message_circle_head);
                this.textGuestMessage = (TextView)itemView.findViewById(R.id.ch_text_guest_message);
                this.viewGuestMessageEdgeHeadBackground = itemView.findViewById(R.id.ch_view_guest_message_edge_head);
                this.viewGuestMessageCircleHeadBackground = itemView.findViewById(R.id.ch_view_guest_message_circle_head);
                break;
            }
            default: {
                this.rootHostMessageText = (LinearLayout)itemView.findViewById(R.id.ch_root_host_message_text);
                this.frameHostMessageEdgeHead = itemView.findViewById(R.id.ch_view_host_message_edge_head);
                this.frameHostMessageCircleHead = itemView.findViewById(R.id.ch_view_host_message_circle_head);
                this.textHostMessage = (TextView)itemView.findViewById(R.id.ch_text_host_message);
            }
        }
        this.textContentMessageGiantEmoji = (TextView)itemView.findViewById(R.id.ch_text_message_content_giant_emoji);
    }

    @Override
    protected void bind(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
        super.bind(message, messageType, isConnectedMessage);
        if (message != null && CompareUtils.exists((Comparable)((Object)messageType), (Comparable[])new MessageType[]{MessageType.GUEST, MessageType.HOST})) {
            if (message.isDeleted()) {
                if (messageType == MessageType.GUEST) {
                    this.setGuestMessageText(ResUtils.getString("message_stream.message.deleted_message"), isConnectedMessage);
                } else if (messageType == MessageType.HOST) {
                    this.setHostMessageText(ResUtils.getString("message_stream.message.deleted_message"), isConnectedMessage, ResUtils.getColor(R.color.ch_light));
                }
            } else if (message.getFormattedSpanMessage() != null) {
                SpannableStringBuilder formattedMessage = message.getFormattedSpanMessage();
                if (MessageUtils.hasOnlyEmoji(formattedMessage)) {
                    this.setGiantEmoji((CharSequence)formattedMessage);
                } else if (messageType == MessageType.GUEST) {
                    this.setGuestMessageText((CharSequence)formattedMessage, isConnectedMessage);
                } else if (messageType == MessageType.HOST) {
                    this.setHostMessageText((CharSequence)formattedMessage, isConnectedMessage);
                }
            }
        }
    }

    @Override
    protected void resetViews() {
        if (this.rootGuestMessageText != null) {
            this.rootGuestMessageText.setVisibility(8);
        }
        if (this.rootHostMessageText != null) {
            this.rootHostMessageText.setVisibility(8);
        }
    }

    protected void setGuestMessageText(CharSequence formattedMessage, boolean isConnectedMessage) {
        if (formattedMessage != null && this.rootGuestMessageText != null && this.frameGuestMessageEdgeHead != null && this.frameGuestMessageCircleHead != null && this.textGuestMessage != null && this.viewGuestMessageEdgeHeadBackground != null && this.viewGuestMessageCircleHeadBackground != null) {
            this.rootGuestMessageText.setVisibility(0);
            Views.setVisibility((View)this.frameGuestMessageEdgeHead, !isConnectedMessage);
            Views.setVisibility((View)this.frameGuestMessageCircleHead, isConnectedMessage);
            this.viewGuestMessageEdgeHeadBackground.setBackgroundColor(StyleSelector.getBackColor());
            this.viewGuestMessageCircleHeadBackground.setBackgroundColor(StyleSelector.getBackColor());
            this.textGuestMessage.setBackgroundColor(StyleSelector.getBackColor());
            this.textGuestMessage.setMovementMethod((MovementMethod)CustomMovementMethod.getInstance());
            this.textGuestMessage.setLinkTextColor(StyleSelector.getTextColor());
            this.textGuestMessage.setTextColor(StyleSelector.getTextColor());
            this.textGuestMessage.setText(formattedMessage);
        }
    }

    protected void setHostMessageText(CharSequence formattedMessage, boolean isConnectedMessage) {
        this.setHostMessageText(formattedMessage, isConnectedMessage, ResUtils.getColor(R.color.ch_text_black));
    }

    protected void setHostMessageText(CharSequence formattedMessage, boolean isConnectedMessage, @ColorInt int textColor) {
        if (formattedMessage != null && this.rootHostMessageText != null && this.frameHostMessageEdgeHead != null && this.frameHostMessageCircleHead != null && this.textHostMessage != null) {
            this.rootHostMessageText.setVisibility(0);
            Views.setVisibility(this.frameHostMessageEdgeHead, !isConnectedMessage);
            Views.setVisibility(this.frameHostMessageCircleHead, isConnectedMessage);
            this.textHostMessage.setMovementMethod((MovementMethod)CustomMovementMethod.getInstance());
            this.textHostMessage.setText(formattedMessage);
            this.textHostMessage.setTextColor(textColor);
        }
    }

    protected void setGiantEmoji(CharSequence formattedMessage) {
        if (this.textContentMessageGiantEmoji != null) {
            this.textContentMessageGiantEmoji.setVisibility(0);
            this.textContentMessageGiantEmoji.setText(formattedMessage);
        }
    }
}

