/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.schedulers.SleepingAction;
import com.zoyi.rx.subscriptions.BooleanSubscription;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.concurrent.TimeUnit;

public final class ImmediateScheduler
extends Scheduler {
    public static final ImmediateScheduler INSTANCE = new ImmediateScheduler();

    private ImmediateScheduler() {
    }

    public Scheduler.Worker createWorker() {
        return new InnerImmediateScheduler();
    }

    final class InnerImmediateScheduler
    extends Scheduler.Worker
    implements Subscription {
        final BooleanSubscription innerSubscription = new BooleanSubscription();

        InnerImmediateScheduler() {
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            long execTime = ImmediateScheduler.this.now() + unit.toMillis(delayTime);
            return this.schedule(new SleepingAction(action, this, execTime));
        }

        public Subscription schedule(Action0 action) {
            action.call();
            return Subscriptions.unsubscribed();
        }

        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

