package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.Views;

public class FetchLayout extends FrameLayout {

  private View loader;
  private ErrorRefreshView errorView;
  private ViewGroup container;

  public FetchLayout(@NonNull Context context) {
    super(context);
    init(context);
  }

  public FetchLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public FetchLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_fetch, this, true);

    loader = view.findViewById(R.id.viewFetchLayoutLoader);
    container = view.findViewById(R.id.layoutFetchLayoutContainer);
    errorView = view.findViewById(R.id.layoutFetchLayoutError);
    errorView.setListener(v -> onRefreshClick());
    loader.setVisibility(View.GONE);
    errorView.setVisibility(View.GONE);
  }

  public final void setFetchState(FetchState fetchState) {
    Views.setVisibility(loader, fetchState == FetchState.LOADING);
    Views.setVisibility(container, fetchState == FetchState.COMPLETE);
    Views.setVisibility(errorView, fetchState == FetchState.FAILED);
  }

  protected void onRefreshClick() {
  }

  @Override
  public void addView(View child, int index, ViewGroup.LayoutParams params) {
    if (child == null) {
      return;
    }

    if (child.getId() == R.id.rootFetchLayout ||
        child.getId() == R.id.viewFetchLayoutLoader ||
        child.getId() == R.id.layoutFetchLayoutError ||
        child.getId() == R.id.layoutFetchLayoutContainer
    ) {
      super.addView(child, index, params);
    } else if (container != null) {
      container.addView(child, index, params);
    }
  }
}
