package com.zoyi.channel.plugin.android.util.message_format.message;

import android.graphics.Typeface;
import android.support.v4.util.Pair;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;

import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RegexUtils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 6. 5..
 */

public class MentionMessage implements MessagePattern {

  private Pattern mentionPattern = Pattern.compile("<@[a-zA-Z0-9]+(:[\\d]+)?>");

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {


    for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(mentionPattern.matcher(span))) {
      int start = range.first;
      int end = range.second;

      String plainText = span.toString();

      int center = plainText.substring(start).indexOf(':');

      if (center != -1 && start + center < end) {
        center += start;
        span.delete(center, end - 1);
        center++;
      } else {
        center = end;
      }

      span.delete(center - 1, center);
      span.delete(start, start + 1);
    }

    return span;
  }
}

