package com.zoyi.channel.plugin.android.store2.state;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.store2.callback.StateCallback;

import java.util.concurrent.atomic.AtomicReference;

public class State<E> extends BaseState<E> {

  private AtomicReference<E> data;
  protected E defaultData;
  private StateCallback<E> callback;

  public State() {
    super();
    this.defaultData = null;
    this.callback = null;
    this.data = new AtomicReference<>(null);
  }

  public State(E data) {
    super();
    this.defaultData = data;
    this.callback = null;
    this.data = new AtomicReference<>(data);
  }

  public State(StateCallback<E> callback) {
    super();
    this.defaultData = null;
    this.callback = callback;
    this.data = new AtomicReference<>(null);
  }

  public State(E data, StateCallback<E> callback) {
    super();
    this.defaultData = data;
    this.callback = callback;
    this.data = new AtomicReference<>(data);
  }

  public void set(E data) {
    if (callback == null || callback.updated(this.data.get(), data)) {
      this.data.set(data);
      post();
    }
  }

  @Nullable
  @Override
  public E get() {
    return this.data.get();
  }

  @Override
  public void reset() {
    this.set(defaultData);
  }
}
