package com.zoyi.channel.plugin.android.store2.state;

import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.UpdatableEntity;
import com.zoyi.channel.plugin.android.util.CompareUtils;

public class EntityMapState<E extends Entity> extends MapState<String, E> {

  public EntityMapState() {
    super(Entity::getId);
  }

  @Override
  protected boolean canUpdate(E oldbie, E newbie) {
    if (oldbie instanceof UpdatableEntity && newbie instanceof UpdatableEntity) {
      return CompareUtils.compare(((UpdatableEntity) oldbie).getUpdatedAt(), ((UpdatableEntity) newbie).getUpdatedAt()) <= 0;
    }
    return true;
  }
}
