package com.zoyi.channel.plugin.android.model;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PopupItem;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.model.rest.PushBot;
import com.zoyi.channel.plugin.android.model.rest.PushBotVariant;
import com.zoyi.channel.plugin.android.selector2.BotSelector;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by jerry on 2018. 11. 23..
 */

public class PushBotItem implements Entity, PopupItem {

  @NonNull
  private PushBot pushBot;
  @Nullable
  private PushBotVariant pushBotVariant;
  private long createdAt;
  private int alertCount;
  private boolean removed;
  private boolean popup;
  private SpannableStringBuilder formattedSpanMessage;
  @Nullable
  private Activity targetActivity;

  public static PushBotItem newInstance(@NonNull PushBot pushBot, @Nullable PushBotVariant pushBotVariant, @Nullable Activity activity) {
    return new PushBotItem(pushBot, pushBotVariant, activity);
  }

  private PushBotItem(@NonNull PushBot pushBot, @Nullable PushBotVariant pushBotVariant, @Nullable Activity activity) {
    this.pushBot = pushBot;
    this.pushBotVariant = pushBotVariant;
    this.createdAt = TimeUtils.getCurrentTime();
    this.alertCount = 1;
    this.removed = false;
    this.popup = pushBotVariant != null;
    this.formattedSpanMessage = pushBotVariant != null
        ? ParseUtils.parseMessage(this.getTitle(), pushBotVariant.getMessage())
        : new SpannableStringBuilder();
    this.targetActivity = activity;
  }

  // PushBot variant id
  @NonNull
  @Override
  public String getId() {
    return pushBot.getId();
  }

  @Override
  public long getCreatedAt() {
    return createdAt;
  }

  @Nullable
  @Override
  public ProfileEntity getProfile() {
    if (pushBotVariant != null) {
      return BotSelector.getBotByName(pushBotVariant.getBotName());
    }
    return null;
  }

  @Nullable
  public String getBotId() {
    if (pushBotVariant != null) {
      Bot bot = BotSelector.getBotByName(pushBotVariant.getBotName());
      if (bot != null) {
        return bot.getId();
      }
    }
    return null;
  }

  @Nullable
  @Override
  public String getTitle() {
    if (pushBotVariant != null) {
      return pushBotVariant.getTitle();
    }
    return null;
  }

  @NonNull
  public String getMessage() {
    if (pushBotVariant != null) {
      return pushBotVariant.getMessage();
    }
    return "";
  }

  @NonNull
  @Override
  public SpannableStringBuilder getFormattedSpanMessage() {
    return formattedSpanMessage;
  }

  @Nullable
  public String getButtonTitle() {
    if (pushBotVariant != null) {
      return pushBotVariant.getButtonTitle();
    }
    return null;
  }

  @Nullable
  public String getButtonRedirectUrl() {
    if (pushBotVariant != null) {
      return pushBotVariant.getButtonRedirectUrl();
    }
    return null;
  }

  @Nullable
  public PreviewThumb getImageThumb() {
    if (pushBotVariant != null) {
      return pushBotVariant.getImageThumb();
    }
    return null;
  }

  @Nullable
  public String getAttachment() {
    if (pushBotVariant != null) {
      return pushBotVariant.getAttachment();
    }
    return null;
  }

  @Nullable
  public String getImageRedirectUrl() {
    if (pushBotVariant != null) {
      return pushBotVariant.getImageRedirectUrl();
    }
    return null;
  }

  public int getAlertCount() {
    return alertCount;
  }

  @Nullable
  public Activity getTargetActivity() {
    return targetActivity;
  }

  public void read() {
    alertCount = 0;
  }

  public void hidePopup() {
    this.popup = false;
    this.targetActivity = null;
  }

  public void remove() {
    this.alertCount = 0;
    this.popup = false;
    this.removed = true;
    this.targetActivity = null;
  }

  public boolean isActive() {
    return pushBotVariant != null && !removed;
  }

  public boolean shouldShowToPopup() {
    return isActive() && popup;
  }
}
