/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector2.PluginSelector;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.view.popup.BasePopupView;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.rx.functions.Action1;

public class PushBotPopupView
extends BasePopupView {
    private ViewGroup layoutPushBotPopupImage;
    private ImageView imagePushBotPopupImage;
    private FrameLayout buttonPushBotPopupButton;
    private View viewPushBotPopupButtonContent;
    private ImageView imagePushBotPopupButtonContent;
    @Nullable
    private OnPushBotClickListener onPushBotClickListener;
    @Nullable
    private PushBotItem pushBotItem;
    @Nullable
    private Binder binder;

    public PushBotPopupView(@NonNull Context context) {
        super(context);
    }

    public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.layoutPushBotPopupImage = (ViewGroup)this.root.findViewById(R.id.ch_layout_popup_image);
        this.imagePushBotPopupImage = (ImageView)this.root.findViewById(R.id.ch_image_popup_image);
        this.viewPushBotPopupButtonContent = this.root.findViewById(R.id.ch_view_popup_button_content);
        this.imagePushBotPopupButtonContent = (ImageView)this.root.findViewById(R.id.ch_image_popup_button_content);
        this.buttonPushBotPopupButton = (FrameLayout)this.root.findViewById(R.id.ch_layout_popup_button);
        this.root.setOnClickListener(v -> {
            if (this.pushBotItem != null && this.onPushBotClickListener != null) {
                this.onPushBotClickListener.onPushBotClick(this.pushBotItem.getId());
            }
            this.requestHide();
        });
        this.layoutPushBotPopupImage.setOnClickListener(v -> {
            if (this.pushBotItem != null && this.onPushBotClickListener != null) {
                this.onPushBotClickListener.onPushBotContentsClick(this.pushBotItem.getId(), this.pushBotItem.getImageRedirectUrl());
            }
            this.requestHide();
        });
        this.buttonPushBotPopupButton.setOnClickListener(v -> {
            if (this.pushBotItem != null && this.onPushBotClickListener != null) {
                this.onPushBotClickListener.onPushBotContentsClick(this.pushBotItem.getId(), this.pushBotItem.getButtonRedirectUrl());
            }
            this.requestHide();
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = PluginSelector.bindPlugin((Action1<Plugin>)((Action1)plugin -> {
            this.viewPushBotPopupButtonContent.setBackgroundColor(plugin.getBackgroundColor());
            this.imagePushBotPopupButtonContent.setImageResource(plugin.getTextColor() == -16777216 ? R.drawable.arrow_right_bk : R.drawable.arrow_right_wh);
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
        }
    }

    public void setPushBotClickListener(OnPushBotClickListener onPushBotClickListener) {
        this.onPushBotClickListener = onPushBotClickListener;
    }

    public void show(@NonNull PushBotItem pushBotItem) {
        this.pushBotItem = pushBotItem;
        super.bindPopupData(pushBotItem);
        this.bindPushBotItem(pushBotItem);
        this.root.setVisibility(0);
    }

    private void bindPushBotItem(@NonNull PushBotItem pushBotItem) {
        this.buttonPushBotPopupButton.setVisibility(8);
        this.layoutPushBotPopupImage.setVisibility(8);
        if (pushBotItem.getAttachment() != null) {
            switch (pushBotItem.getAttachment()) {
                case "button": {
                    if (pushBotItem.getButtonTitle() == null) break;
                    this.buttonPushBotPopupButton.setVisibility(0);
                    break;
                }
                case "image": {
                    PreviewThumb imagePreview = pushBotItem.getImageThumb();
                    if (imagePreview == null || imagePreview.getUrl() == null) break;
                    Glide.with((Context)this.context).load(imagePreview.getUrl()).centerCrop().diskCacheStrategy(DiskCacheStrategy.SOURCE).into(this.imagePushBotPopupImage);
                    this.layoutPushBotPopupImage.setVisibility(0);
                }
            }
        }
    }

    @Override
    protected void requestHide() {
        if (this.pushBotItem != null) {
            this.pushBotItem.hidePopup();
            PushBotStore.get().pushBots.upsert(this.pushBotItem);
            this.pushBotItem = null;
        }
    }

    @Override
    protected void resetPopupContent() {
        this.buttonPushBotPopupButton.setVisibility(8);
        this.layoutPushBotPopupImage.setVisibility(8);
    }
}

