package com.zoyi.channel.plugin.android.view.scrollview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;

public class RecyclerBottomPlaceholderLayout extends BottomPlaceholderLayout<RecyclerView> {

  public RecyclerBottomPlaceholderLayout(Context context) {
    super(context);
  }

  public RecyclerBottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public RecyclerBottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  public void setRecyclerView(@Nullable RecyclerView recyclerView) {
    setScrollableView(recyclerView, null);
  }

  public void setRecyclerView(
      @Nullable RecyclerView recyclerView,
      @Nullable OnScrollableStateChangeListener onScrollableStateChangeListener
  ) {
    setScrollableView(recyclerView, onScrollableStateChangeListener);
  }

  @Override
  protected boolean canScroll(RecyclerView recyclerView, int height) {
    return recyclerView.canScrollVertically(-1) || recyclerView.canScrollVertically(1);
  }

  @Override
  protected boolean isOnBottom(RecyclerView scrollableView) {
    return !scrollableView.canScrollVertically(1);
  }

  @Override
  protected void scrollToBottom(RecyclerView scrollableView) {
    RecyclerView.LayoutManager layoutManager = scrollableView.getLayoutManager();
    RecyclerView.Adapter adapter = scrollableView.getAdapter();

    if (adapter != null && layoutManager != null) {
      layoutManager.scrollToPosition(adapter.getItemCount() - 1);
    }
  }
}
