package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PopupItem;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

/**
 * Created by jerry on 2018. 11. 20..
 */

public abstract class BasePopupView extends LinearLayout {

  private static final int MAX_POPUP_WIDTH = 534; // Max width (520) + side padding

  protected Context context;

  protected View root;
  protected LinearLayout buttonPopupClose;
  protected AvatarLayout avatarPopup;
  protected TextView textPopupName;
  protected TextView textPopupTime;
  protected TextView textPopupMessage;

  public BasePopupView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  // Resize popup width
  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    int maxPopupWidth = (int) Utils.dpToPx(MAX_POPUP_WIDTH);
    int popupWidth = View.MeasureSpec.getSize(widthMeasureSpec);

    if (maxPopupWidth < popupWidth) {
      popupWidth = maxPopupWidth;
    }

    widthMeasureSpec = MeasureSpec.makeMeasureSpec(popupWidth, MeasureSpec.getMode(widthMeasureSpec));

    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
  }

  @Initializer
  protected void init(Context context) {
    this.context = context;

    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_popup, this, true);
    root.setVisibility(GONE);

    buttonPopupClose = root.findViewById(R.id.ch_button_popup_close);
    avatarPopup = root.findViewById(R.id.ch_avatar_popup);
    textPopupName = root.findViewById(R.id.ch_text_popup_name);
    textPopupTime = root.findViewById(R.id.ch_text_popup_time);

    textPopupMessage = root.findViewById(R.id.ch_text_popup_message);

    buttonPopupClose.setOnClickListener(v -> requestHide());
  }

  protected void bindPopupData(@NonNull PopupItem popupItem) {

    // Reset popup content visibility (button, image.. etc)
    resetPopupContent();

    // Set avatar, bot name, time0

    ProfileEntity person = popupItem.getProfile();
    avatarPopup.set(person);
    textPopupName.setText(person != null ? person.getName() : ResUtils.getUnknown());
    textPopupTime.setText(TimeUtils.getTime(popupItem.getCreatedAt()));

    // Set message
    textPopupMessage.setText(popupItem.getFormattedSpanMessage());

    // Set alarm
    if (PrefSupervisor.isEnabledPushAlarm(context)) {
      AlarmCenter.alarm(context);
    }
  }

  abstract protected void requestHide();

  public void hideView() {
    root.setVisibility(View.GONE);
  }

  abstract protected void resetPopupContent();
}
