package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store2.BotStore;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;

/**
 * Created by mika on 2016. 12. 6..
 */
public class PluginWrapper extends BaseRepo {

  private Plugin plugin;
  private Channel channel;
  private User user;
  private Veil veil;
  private Bot bot;

  public Plugin getPlugin() {
    return plugin;
  }

  public Channel getChannel() {
    return channel;
  }

  public User getUser() {
    return user;
  }

  public Veil getVeil() {
    return veil;
  }

  public Bot getBot() {
    return bot;
  }

  public Guest getGuest() {
    return user != null ? user : veil;
  }

  @Override
  public void set() {
    PluginStore.get().pluginState.set(plugin);
    ChannelStore.get().channelState.set(channel);
    GuestStore.get().guest.set(getGuest());
    BotStore.get().bots.upsert(bot);

    if (bot != null) {
      BotStore.get().defaultBotId.set(bot.getId());
    }
  }

  @Override
  public boolean isValid() {
    return plugin != null && channel != null && (user != null || veil != null);
  }

  public boolean canUseMobileSDK() {
    return channel != null && channel.canUseMobileSdk();
  }
}
