package com.zoyi.channel.plugin.android.model.rest;

/**
 * Created by mika on 2017. 1. 31..
 */
public class TimeRange {

  private final static int DAY_IN_MINUTES = 24 * 60;

  public TimeRange(Integer from, Integer to) {
    this.from = from;
    this.to = to;
  }

  public TimeRange(int fromHours, int fromMinutes, int toHours, int toMinutes) {
    this.from = fromHours * 60 + fromMinutes;
    this.to = toHours * 60 + toMinutes;
  }

  private Integer from;
  private Integer to;

  public Integer getFrom() {
    return from;
  }

  public Integer getTo() {
    return to;
  }

  public boolean isValid() {
    return from != null && to != null && from < to && from >= 0 && from <= DAY_IN_MINUTES && to >= 0 && to <= DAY_IN_MINUTES;
  }
}
