/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.persistentcookiejar;

import com.zoyi.channel.plugin.android.util.persistentcookiejar.ClearableCookieJar;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.cache.CookieCache;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.persistence.CookiePersistor;
import com.zoyi.okhttp3.Cookie;
import com.zoyi.okhttp3.HttpUrl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PersistentCookieJar
implements ClearableCookieJar {
    private CookieCache cache;
    private CookiePersistor persistor;

    public PersistentCookieJar(CookieCache cache, CookiePersistor persistor) {
        this.cache = cache;
        this.persistor = persistor;
        this.cache.addAll(persistor.loadAll());
    }

    public synchronized void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.cache.addAll(cookies);
        this.persistor.saveAll(PersistentCookieJar.filterPersistentCookies(cookies));
    }

    private static List<Cookie> filterPersistentCookies(List<Cookie> cookies) {
        ArrayList<Cookie> persistentCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (!cookie.persistent()) continue;
            persistentCookies.add(cookie);
        }
        return persistentCookies;
    }

    public synchronized List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> cookiesToRemove = new ArrayList<Cookie>();
        HashMap<String, Cookie> validCookies = new HashMap<String, Cookie>();
        Iterator it = this.cache.iterator();
        while (it.hasNext()) {
            Cookie oldbie;
            Cookie currentCookie = (Cookie)it.next();
            if (PersistentCookieJar.isCookieExpired(currentCookie)) {
                cookiesToRemove.add(currentCookie);
                it.remove();
                continue;
            }
            if (!currentCookie.matches(url) || !PersistentCookieJar.canUpsert(oldbie = validCookies.containsKey(currentCookie.name()) ? (Cookie)validCookies.get(currentCookie.name()) : null, currentCookie)) continue;
            validCookies.put(currentCookie.name(), currentCookie);
        }
        this.persistor.removeAll(cookiesToRemove);
        return new ArrayList<Cookie>(validCookies.values());
    }

    private static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    private static boolean canUpsert(Cookie oldbie, Cookie newbie) {
        if (newbie == null) {
            return false;
        }
        if (oldbie == null) {
            return true;
        }
        String oldDomain = oldbie.domain();
        String newDomain = newbie.domain();
        if (newDomain == null) {
            return false;
        }
        if (oldDomain == null) {
            return true;
        }
        return oldDomain.length() < newDomain.length();
    }

    @Override
    public synchronized void clearSession() {
        this.cache.clear();
        this.cache.addAll(this.persistor.loadAll());
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
        this.persistor.clear();
    }
}

