/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.textview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EllipsizeTextView
extends AppCompatTextView {
    private static final String DEFAULT_ELLIPSIZE_TEXT = "...";
    private CharSequence mEllipsizeText = "...";
    private CharSequence mOriginText = "";
    private int mEllipsizeIndex;
    private int mMaxLines;
    private boolean mIsExactlyMode;
    private boolean mEnableUpdateOriginText = true;

    public EllipsizeTextView(Context context) {
        this(context, null);
    }

    public EllipsizeTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public EllipsizeTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setMaxLines(int maxLines) {
        if (this.mMaxLines != maxLines) {
            super.setMaxLines(maxLines);
            this.mMaxLines = maxLines;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setText(this.mOriginText);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        try {
            this.mIsExactlyMode = View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000;
            Layout layout2 = this.getLayout();
            if (layout2 != null && (this.isExceedMaxLine(layout2) || this.isOutOfBounds(layout2))) {
                this.adjustEllipsizeEndText(layout2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mEnableUpdateOriginText) {
            this.mOriginText = text;
        }
        super.setText(text, type);
        if (this.mIsExactlyMode) {
            this.requestLayout();
        }
    }

    private boolean isExceedMaxLine(Layout layout2) {
        return layout2.getLineCount() > this.mMaxLines && this.mMaxLines > 0;
    }

    private boolean isOutOfBounds(Layout layout2) {
        return layout2.getHeight() > this.getMeasuredHeight() - this.getPaddingBottom() - this.getPaddingTop();
    }

    private void adjustEllipsizeEndText(Layout layout2) {
        CharSequence originText = this.mOriginText;
        CharSequence restSuffixText = originText.subSequence(originText.length() - this.mEllipsizeIndex, originText.length());
        int width = layout2.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int maxLineCount = Math.max(1, this.computeMaxLineCount(layout2));
        int lastLineWidth = (int)layout2.getLineWidth(maxLineCount - 1);
        int mLastCharacterIndex = layout2.getLineEnd(maxLineCount - 1);
        int suffixWidth = (int)(Layout.getDesiredWidth((CharSequence)this.mEllipsizeText, (TextPaint)this.getPaint()) + Layout.getDesiredWidth((CharSequence)restSuffixText, (TextPaint)this.getPaint())) + 1;
        this.mEnableUpdateOriginText = false;
        if (lastLineWidth + suffixWidth > width) {
            int widthDiff = lastLineWidth + suffixWidth - width;
            int removedCharacterCount = this.computeRemovedEllipsizeEndCharacterCount(widthDiff, originText.subSequence(0, mLastCharacterIndex));
            this.setText(originText.subSequence(0, mLastCharacterIndex - removedCharacterCount));
            this.append(this.mEllipsizeText);
            this.append(restSuffixText);
        } else {
            this.setText(originText.subSequence(0, mLastCharacterIndex));
            this.append(this.mEllipsizeText);
            this.append(restSuffixText);
        }
        this.mEnableUpdateOriginText = true;
    }

    private int computeMaxLineCount(Layout layout2) {
        int availableHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        for (int i = 0; i < layout2.getLineCount(); ++i) {
            if (availableHeight >= layout2.getLineBottom(i)) continue;
            return i;
        }
        return layout2.getLineCount();
    }

    private int computeRemovedEllipsizeEndCharacterCount(int widthDiff, CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 0;
        }
        List<Range<Integer>> characterStyleRanges = this.computeCharacterStyleRanges(text);
        String textStr = text.toString();
        int characterIndex = text.length();
        int codePointIndex = textStr.codePointCount(0, text.length());
        int currentRemovedWidth = 0;
        while (codePointIndex > 0 && widthDiff > currentRemovedWidth) {
            Range<Integer> characterStyleRange;
            if ((characterStyleRange = this.computeCharacterStyleRange(characterStyleRanges, characterIndex = textStr.offsetByCodePoints(0, --codePointIndex))) != null) {
                characterIndex = characterStyleRange.getLower();
                codePointIndex = textStr.codePointCount(0, characterIndex);
            }
            currentRemovedWidth = (int)Layout.getDesiredWidth((CharSequence)text.subSequence(characterIndex, text.length()), (TextPaint)this.getPaint());
        }
        return text.length() - textStr.offsetByCodePoints(0, codePointIndex);
    }

    @Nullable
    private Range<Integer> computeCharacterStyleRange(List<Range<Integer>> characterStyleRanges, int index) {
        if (characterStyleRanges == null || characterStyleRanges.isEmpty()) {
            return null;
        }
        for (Range<Integer> characterStyleRange : characterStyleRanges) {
            if (!characterStyleRange.contains(index)) continue;
            return characterStyleRange;
        }
        return null;
    }

    private List<Range<Integer>> computeCharacterStyleRanges(CharSequence text) {
        SpannableStringBuilder ssb = SpannableStringBuilder.valueOf((CharSequence)text);
        CharacterStyle[] characterStyles = (CharacterStyle[])ssb.getSpans(0, ssb.length(), CharacterStyle.class);
        if (characterStyles == null || characterStyles.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Range<Integer>> ranges = new ArrayList<Range<Integer>>();
        for (CharacterStyle characterStyle : characterStyles) {
            ranges.add(new Range<Integer>(ssb.getSpanStart((Object)characterStyle), ssb.getSpanEnd((Object)characterStyle)));
        }
        return ranges;
    }

    public void setEllipsizeText(CharSequence ellipsizeText, int ellipsizeIndex) {
        this.mEllipsizeText = ellipsizeText;
        this.mEllipsizeIndex = ellipsizeIndex;
    }

    public static final class Range<T extends Comparable<? super T>> {
        private final T mLower;
        private final T mUpper;

        public Range(T lower, T upper) {
            this.mLower = lower;
            this.mUpper = upper;
            if (lower.compareTo(upper) > 0) {
                throw new IllegalArgumentException("lower must be less than or equal to upper");
            }
        }

        public T getLower() {
            return this.mLower;
        }

        public T getUpper() {
            return this.mUpper;
        }

        public boolean contains(T value) {
            boolean gteLower = value.compareTo(this.mLower) >= 0;
            boolean lteUpper = value.compareTo(this.mUpper) < 0;
            return gteLower && lteUpper;
        }
    }
}

